// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/connectors/v1/connectors_service.proto

#include "google/cloud/connectors/v1/connectors_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace connectors_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConnectorsClient::ConnectorsClient(
    std::shared_ptr<ConnectorsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ConnectorsClient::~ConnectorsClient() = default;

StreamRange<google::cloud::connectors::v1::Connection>
ConnectorsClient::ListConnections(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::ListConnectionsRequest request;
  request.set_parent(parent);
  return connection_->ListConnections(request);
}

StreamRange<google::cloud::connectors::v1::Connection>
ConnectorsClient::ListConnections(
    google::cloud::connectors::v1::ListConnectionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConnections(std::move(request));
}

StatusOr<google::cloud::connectors::v1::Connection>
ConnectorsClient::GetConnection(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::GetConnectionRequest request;
  request.set_name(name);
  return connection_->GetConnection(request);
}

StatusOr<google::cloud::connectors::v1::Connection>
ConnectorsClient::GetConnection(
    google::cloud::connectors::v1::GetConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConnection(request);
}

future<StatusOr<google::cloud::connectors::v1::Connection>>
ConnectorsClient::CreateConnection(
    std::string const& parent,
    google::cloud::connectors::v1::Connection const& connection,
    std::string const& connection_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::CreateConnectionRequest request;
  request.set_parent(parent);
  *request.mutable_connection() = connection;
  request.set_connection_id(connection_id);
  return connection_->CreateConnection(request);
}

StatusOr<google::longrunning::Operation> ConnectorsClient::CreateConnection(
    NoAwaitTag, std::string const& parent,
    google::cloud::connectors::v1::Connection const& connection,
    std::string const& connection_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::CreateConnectionRequest request;
  request.set_parent(parent);
  *request.mutable_connection() = connection;
  request.set_connection_id(connection_id);
  return connection_->CreateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::connectors::v1::Connection>>
ConnectorsClient::CreateConnection(
    google::cloud::connectors::v1::CreateConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConnection(request);
}

StatusOr<google::longrunning::Operation> ConnectorsClient::CreateConnection(
    NoAwaitTag,
    google::cloud::connectors::v1::CreateConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::connectors::v1::Connection>>
ConnectorsClient::CreateConnection(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConnection(operation);
}

future<StatusOr<google::cloud::connectors::v1::Connection>>
ConnectorsClient::UpdateConnection(
    google::cloud::connectors::v1::Connection const& connection,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::UpdateConnectionRequest request;
  *request.mutable_connection() = connection;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateConnection(request);
}

StatusOr<google::longrunning::Operation> ConnectorsClient::UpdateConnection(
    NoAwaitTag, google::cloud::connectors::v1::Connection const& connection,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::UpdateConnectionRequest request;
  *request.mutable_connection() = connection;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::connectors::v1::Connection>>
ConnectorsClient::UpdateConnection(
    google::cloud::connectors::v1::UpdateConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConnection(request);
}

StatusOr<google::longrunning::Operation> ConnectorsClient::UpdateConnection(
    NoAwaitTag,
    google::cloud::connectors::v1::UpdateConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::connectors::v1::Connection>>
ConnectorsClient::UpdateConnection(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConnection(operation);
}

future<StatusOr<google::cloud::connectors::v1::OperationMetadata>>
ConnectorsClient::DeleteConnection(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::DeleteConnectionRequest request;
  request.set_name(name);
  return connection_->DeleteConnection(request);
}

StatusOr<google::longrunning::Operation> ConnectorsClient::DeleteConnection(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::DeleteConnectionRequest request;
  request.set_name(name);
  return connection_->DeleteConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::connectors::v1::OperationMetadata>>
ConnectorsClient::DeleteConnection(
    google::cloud::connectors::v1::DeleteConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConnection(request);
}

StatusOr<google::longrunning::Operation> ConnectorsClient::DeleteConnection(
    NoAwaitTag,
    google::cloud::connectors::v1::DeleteConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::connectors::v1::OperationMetadata>>
ConnectorsClient::DeleteConnection(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConnection(operation);
}

StreamRange<google::cloud::connectors::v1::Provider>
ConnectorsClient::ListProviders(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::ListProvidersRequest request;
  request.set_parent(parent);
  return connection_->ListProviders(request);
}

StreamRange<google::cloud::connectors::v1::Provider>
ConnectorsClient::ListProviders(
    google::cloud::connectors::v1::ListProvidersRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListProviders(std::move(request));
}

StatusOr<google::cloud::connectors::v1::Provider> ConnectorsClient::GetProvider(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::GetProviderRequest request;
  request.set_name(name);
  return connection_->GetProvider(request);
}

StatusOr<google::cloud::connectors::v1::Provider> ConnectorsClient::GetProvider(
    google::cloud::connectors::v1::GetProviderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetProvider(request);
}

StreamRange<google::cloud::connectors::v1::Connector>
ConnectorsClient::ListConnectors(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::ListConnectorsRequest request;
  request.set_parent(parent);
  return connection_->ListConnectors(request);
}

StreamRange<google::cloud::connectors::v1::Connector>
ConnectorsClient::ListConnectors(
    google::cloud::connectors::v1::ListConnectorsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConnectors(std::move(request));
}

StatusOr<google::cloud::connectors::v1::Connector>
ConnectorsClient::GetConnector(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::GetConnectorRequest request;
  request.set_name(name);
  return connection_->GetConnector(request);
}

StatusOr<google::cloud::connectors::v1::Connector>
ConnectorsClient::GetConnector(
    google::cloud::connectors::v1::GetConnectorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConnector(request);
}

StreamRange<google::cloud::connectors::v1::ConnectorVersion>
ConnectorsClient::ListConnectorVersions(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::ListConnectorVersionsRequest request;
  request.set_parent(parent);
  return connection_->ListConnectorVersions(request);
}

StreamRange<google::cloud::connectors::v1::ConnectorVersion>
ConnectorsClient::ListConnectorVersions(
    google::cloud::connectors::v1::ListConnectorVersionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConnectorVersions(std::move(request));
}

StatusOr<google::cloud::connectors::v1::ConnectorVersion>
ConnectorsClient::GetConnectorVersion(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::GetConnectorVersionRequest request;
  request.set_name(name);
  return connection_->GetConnectorVersion(request);
}

StatusOr<google::cloud::connectors::v1::ConnectorVersion>
ConnectorsClient::GetConnectorVersion(
    google::cloud::connectors::v1::GetConnectorVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConnectorVersion(request);
}

StatusOr<google::cloud::connectors::v1::ConnectionSchemaMetadata>
ConnectorsClient::GetConnectionSchemaMetadata(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::GetConnectionSchemaMetadataRequest request;
  request.set_name(name);
  return connection_->GetConnectionSchemaMetadata(request);
}

StatusOr<google::cloud::connectors::v1::ConnectionSchemaMetadata>
ConnectorsClient::GetConnectionSchemaMetadata(
    google::cloud::connectors::v1::GetConnectionSchemaMetadataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConnectionSchemaMetadata(request);
}

future<StatusOr<google::cloud::connectors::v1::ConnectionSchemaMetadata>>
ConnectorsClient::RefreshConnectionSchemaMetadata(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::RefreshConnectionSchemaMetadataRequest request;
  request.set_name(name);
  return connection_->RefreshConnectionSchemaMetadata(request);
}

StatusOr<google::longrunning::Operation>
ConnectorsClient::RefreshConnectionSchemaMetadata(NoAwaitTag,
                                                  std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::RefreshConnectionSchemaMetadataRequest request;
  request.set_name(name);
  return connection_->RefreshConnectionSchemaMetadata(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::connectors::v1::ConnectionSchemaMetadata>>
ConnectorsClient::RefreshConnectionSchemaMetadata(
    google::cloud::connectors::v1::RefreshConnectionSchemaMetadataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RefreshConnectionSchemaMetadata(request);
}

StatusOr<google::longrunning::Operation>
ConnectorsClient::RefreshConnectionSchemaMetadata(
    NoAwaitTag,
    google::cloud::connectors::v1::RefreshConnectionSchemaMetadataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RefreshConnectionSchemaMetadata(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::connectors::v1::ConnectionSchemaMetadata>>
ConnectorsClient::RefreshConnectionSchemaMetadata(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RefreshConnectionSchemaMetadata(operation);
}

StreamRange<google::cloud::connectors::v1::RuntimeEntitySchema>
ConnectorsClient::ListRuntimeEntitySchemas(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::ListRuntimeEntitySchemasRequest request;
  request.set_parent(parent);
  return connection_->ListRuntimeEntitySchemas(request);
}

StreamRange<google::cloud::connectors::v1::RuntimeEntitySchema>
ConnectorsClient::ListRuntimeEntitySchemas(
    google::cloud::connectors::v1::ListRuntimeEntitySchemasRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRuntimeEntitySchemas(std::move(request));
}

StreamRange<google::cloud::connectors::v1::RuntimeActionSchema>
ConnectorsClient::ListRuntimeActionSchemas(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::ListRuntimeActionSchemasRequest request;
  request.set_parent(parent);
  return connection_->ListRuntimeActionSchemas(request);
}

StreamRange<google::cloud::connectors::v1::RuntimeActionSchema>
ConnectorsClient::ListRuntimeActionSchemas(
    google::cloud::connectors::v1::ListRuntimeActionSchemasRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRuntimeActionSchemas(std::move(request));
}

StatusOr<google::cloud::connectors::v1::RuntimeConfig>
ConnectorsClient::GetRuntimeConfig(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::GetRuntimeConfigRequest request;
  request.set_name(name);
  return connection_->GetRuntimeConfig(request);
}

StatusOr<google::cloud::connectors::v1::RuntimeConfig>
ConnectorsClient::GetRuntimeConfig(
    google::cloud::connectors::v1::GetRuntimeConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRuntimeConfig(request);
}

StatusOr<google::cloud::connectors::v1::Settings>
ConnectorsClient::GetGlobalSettings(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::connectors::v1::GetGlobalSettingsRequest request;
  request.set_name(name);
  return connection_->GetGlobalSettings(request);
}

StatusOr<google::cloud::connectors::v1::Settings>
ConnectorsClient::GetGlobalSettings(
    google::cloud::connectors::v1::GetGlobalSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGlobalSettings(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace connectors_v1
}  // namespace cloud
}  // namespace google
