// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudtrace/v1/trace.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRACE_V1_INTERNAL_TRACE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRACE_V1_INTERNAL_TRACE_TRACING_CONNECTION_H

#include "google/cloud/trace/v1/trace_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace trace_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class TraceServiceTracingConnection : public trace_v1::TraceServiceConnection {
 public:
  ~TraceServiceTracingConnection() override = default;

  explicit TraceServiceTracingConnection(
      std::shared_ptr<trace_v1::TraceServiceConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::devtools::cloudtrace::v1::Trace> ListTraces(
      google::devtools::cloudtrace::v1::ListTracesRequest request) override;

  StatusOr<google::devtools::cloudtrace::v1::Trace> GetTrace(
      google::devtools::cloudtrace::v1::GetTraceRequest const& request)
      override;

  Status PatchTraces(google::devtools::cloudtrace::v1::PatchTracesRequest const&
                         request) override;

 private:
  std::shared_ptr<trace_v1::TraceServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<trace_v1::TraceServiceConnection>
MakeTraceServiceTracingConnection(
    std::shared_ptr<trace_v1::TraceServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRACE_V1_INTERNAL_TRACE_TRACING_CONNECTION_H
