// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/v1/workflows.proto

#include "google/cloud/workflows/v1/internal/workflows_connection_impl.h"
#include "google/cloud/workflows/v1/internal/workflows_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace workflows_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<workflows_v1::WorkflowsRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<workflows_v1::WorkflowsRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<workflows_v1::WorkflowsBackoffPolicyOption>()->clone();
}

std::unique_ptr<workflows_v1::WorkflowsConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<workflows_v1::WorkflowsConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<workflows_v1::WorkflowsPollingPolicyOption>()->clone();
}

}  // namespace

WorkflowsConnectionImpl::WorkflowsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<workflows_v1_internal::WorkflowsStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      WorkflowsConnection::options())) {}

StreamRange<google::cloud::workflows::v1::Workflow>
WorkflowsConnectionImpl::ListWorkflows(
    google::cloud::workflows::v1::ListWorkflowsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListWorkflows(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::workflows::v1::Workflow>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<workflows_v1::WorkflowsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::workflows::v1::ListWorkflowsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::workflows::v1::ListWorkflowsRequest const&
                       request) {
              return stub->ListWorkflows(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::workflows::v1::ListWorkflowsResponse r) {
        std::vector<google::cloud::workflows::v1::Workflow> result(
            r.workflows().size());
        auto& messages = *r.mutable_workflows();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::workflows::v1::Workflow>
WorkflowsConnectionImpl::GetWorkflow(
    google::cloud::workflows::v1::GetWorkflowRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetWorkflow(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::workflows::v1::GetWorkflowRequest const& request) {
        return stub_->GetWorkflow(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsConnectionImpl::CreateWorkflow(
    google::cloud::workflows::v1::CreateWorkflowRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateWorkflow(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workflows::v1::Workflow>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::workflows::v1::CreateWorkflowRequest const& request) {
        return stub->AsyncCreateWorkflow(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workflows::v1::Workflow>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
WorkflowsConnectionImpl::CreateWorkflow(
    NoAwaitTag,
    google::cloud::workflows::v1::CreateWorkflowRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateWorkflow(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::workflows::v1::CreateWorkflowRequest const& request) {
        return stub_->CreateWorkflow(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsConnectionImpl::CreateWorkflow(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::workflows::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::workflows::v1::Workflow>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateWorkflow",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::workflows::v1::Workflow>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workflows::v1::Workflow>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
WorkflowsConnectionImpl::DeleteWorkflow(
    google::cloud::workflows::v1::DeleteWorkflowRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteWorkflow(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workflows::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::workflows::v1::DeleteWorkflowRequest const& request) {
        return stub->AsyncDeleteWorkflow(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::workflows::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
WorkflowsConnectionImpl::DeleteWorkflow(
    NoAwaitTag,
    google::cloud::workflows::v1::DeleteWorkflowRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteWorkflow(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::workflows::v1::DeleteWorkflowRequest const& request) {
        return stub_->DeleteWorkflow(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
WorkflowsConnectionImpl::DeleteWorkflow(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::workflows::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::workflows::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteWorkflow",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::workflows::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::workflows::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsConnectionImpl::UpdateWorkflow(
    google::cloud::workflows::v1::UpdateWorkflowRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateWorkflow(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workflows::v1::Workflow>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::workflows::v1::UpdateWorkflowRequest const& request) {
        return stub->AsyncUpdateWorkflow(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workflows::v1::Workflow>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
WorkflowsConnectionImpl::UpdateWorkflow(
    NoAwaitTag,
    google::cloud::workflows::v1::UpdateWorkflowRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateWorkflow(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::workflows::v1::UpdateWorkflowRequest const& request) {
        return stub_->UpdateWorkflow(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsConnectionImpl::UpdateWorkflow(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::workflows::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::workflows::v1::Workflow>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateWorkflow",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::workflows::v1::Workflow>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workflows::v1::Workflow>,
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_v1_internal
}  // namespace cloud
}  // namespace google
