// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/notebooks/v1/managed_service.proto

package notebooks

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for listing Managed Notebook Runtimes.
type ListRuntimesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `parent=projects/{project_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum return size of the list call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A previous returned page token that can be used to continue listing
	// from the last result.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRuntimesRequest) Reset() {
	*x = ListRuntimesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuntimesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimesRequest) ProtoMessage() {}

func (x *ListRuntimesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimesRequest.ProtoReflect.Descriptor instead.
func (*ListRuntimesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListRuntimesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRuntimesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRuntimesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for listing Managed Notebook Runtimes.
type ListRuntimesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of returned Runtimes.
	Runtimes []*Runtime `protobuf:"bytes,1,rep,name=runtimes,proto3" json:"runtimes,omitempty"`
	// Page token that can be used to continue listing from the last result in the
	// next list call.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached. For example,
	// ['us-west1', 'us-central1'].
	// A ListRuntimesResponse will only contain either runtimes or unreachables,
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRuntimesResponse) Reset() {
	*x = ListRuntimesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRuntimesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimesResponse) ProtoMessage() {}

func (x *ListRuntimesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimesResponse.ProtoReflect.Descriptor instead.
func (*ListRuntimesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListRuntimesResponse) GetRuntimes() []*Runtime {
	if x != nil {
		return x.Runtimes
	}
	return nil
}

func (x *ListRuntimesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRuntimesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for getting a Managed Notebook Runtime.
type GetRuntimeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRuntimeRequest) Reset() {
	*x = GetRuntimeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRuntimeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRuntimeRequest) ProtoMessage() {}

func (x *GetRuntimeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRuntimeRequest.ProtoReflect.Descriptor instead.
func (*GetRuntimeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetRuntimeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for creating a Managed Notebook Runtime.
type CreateRuntimeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `parent=projects/{project_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User-defined unique ID of this Runtime.
	RuntimeId string `protobuf:"bytes,2,opt,name=runtime_id,json=runtimeId,proto3" json:"runtime_id,omitempty"`
	// Required. The Runtime to be created.
	Runtime *Runtime `protobuf:"bytes,3,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateRuntimeRequest) Reset() {
	*x = CreateRuntimeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRuntimeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRuntimeRequest) ProtoMessage() {}

func (x *CreateRuntimeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRuntimeRequest.ProtoReflect.Descriptor instead.
func (*CreateRuntimeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateRuntimeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRuntimeRequest) GetRuntimeId() string {
	if x != nil {
		return x.RuntimeId
	}
	return ""
}

func (x *CreateRuntimeRequest) GetRuntime() *Runtime {
	if x != nil {
		return x.Runtime
	}
	return nil
}

func (x *CreateRuntimeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for deleting a Managed Notebook Runtime.
type DeleteRuntimeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteRuntimeRequest) Reset() {
	*x = DeleteRuntimeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRuntimeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRuntimeRequest) ProtoMessage() {}

func (x *DeleteRuntimeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRuntimeRequest.ProtoReflect.Descriptor instead.
func (*DeleteRuntimeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteRuntimeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRuntimeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for starting a Managed Notebook Runtime.
type StartRuntimeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *StartRuntimeRequest) Reset() {
	*x = StartRuntimeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartRuntimeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartRuntimeRequest) ProtoMessage() {}

func (x *StartRuntimeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartRuntimeRequest.ProtoReflect.Descriptor instead.
func (*StartRuntimeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{5}
}

func (x *StartRuntimeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StartRuntimeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for stopping a Managed Notebook Runtime.
type StopRuntimeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *StopRuntimeRequest) Reset() {
	*x = StopRuntimeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopRuntimeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopRuntimeRequest) ProtoMessage() {}

func (x *StopRuntimeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopRuntimeRequest.ProtoReflect.Descriptor instead.
func (*StopRuntimeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{6}
}

func (x *StopRuntimeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StopRuntimeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for switching a Managed Notebook Runtime.
type SwitchRuntimeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// machine type.
	MachineType string `protobuf:"bytes,2,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// accelerator config.
	AcceleratorConfig *RuntimeAcceleratorConfig `protobuf:"bytes,3,opt,name=accelerator_config,json=acceleratorConfig,proto3" json:"accelerator_config,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *SwitchRuntimeRequest) Reset() {
	*x = SwitchRuntimeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SwitchRuntimeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SwitchRuntimeRequest) ProtoMessage() {}

func (x *SwitchRuntimeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SwitchRuntimeRequest.ProtoReflect.Descriptor instead.
func (*SwitchRuntimeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{7}
}

func (x *SwitchRuntimeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SwitchRuntimeRequest) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *SwitchRuntimeRequest) GetAcceleratorConfig() *RuntimeAcceleratorConfig {
	if x != nil {
		return x.AcceleratorConfig
	}
	return nil
}

func (x *SwitchRuntimeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for resetting a Managed Notebook Runtime.
type ResetRuntimeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ResetRuntimeRequest) Reset() {
	*x = ResetRuntimeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetRuntimeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetRuntimeRequest) ProtoMessage() {}

func (x *ResetRuntimeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetRuntimeRequest.ProtoReflect.Descriptor instead.
func (*ResetRuntimeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{8}
}

func (x *ResetRuntimeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResetRuntimeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for reporting a Managed Notebook Event.
type ReportRuntimeEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The VM hardware token for authenticating the VM.
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	VmId string `protobuf:"bytes,2,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
	// Required. The Event to be reported.
	Event *Event `protobuf:"bytes,3,opt,name=event,proto3" json:"event,omitempty"`
}

func (x *ReportRuntimeEventRequest) Reset() {
	*x = ReportRuntimeEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportRuntimeEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportRuntimeEventRequest) ProtoMessage() {}

func (x *ReportRuntimeEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportRuntimeEventRequest.ProtoReflect.Descriptor instead.
func (*ReportRuntimeEventRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{9}
}

func (x *ReportRuntimeEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReportRuntimeEventRequest) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

func (x *ReportRuntimeEventRequest) GetEvent() *Event {
	if x != nil {
		return x.Event
	}
	return nil
}

// Request for getting a new access token.
type RefreshRuntimeTokenInternalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The VM hardware token for authenticating the VM.
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	VmId string `protobuf:"bytes,2,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
}

func (x *RefreshRuntimeTokenInternalRequest) Reset() {
	*x = RefreshRuntimeTokenInternalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefreshRuntimeTokenInternalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshRuntimeTokenInternalRequest) ProtoMessage() {}

func (x *RefreshRuntimeTokenInternalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshRuntimeTokenInternalRequest.ProtoReflect.Descriptor instead.
func (*RefreshRuntimeTokenInternalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{10}
}

func (x *RefreshRuntimeTokenInternalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RefreshRuntimeTokenInternalRequest) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

// Response with a new access token.
type RefreshRuntimeTokenInternalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The OAuth 2.0 access token.
	AccessToken string `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// Output only. Token expiration time.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *RefreshRuntimeTokenInternalResponse) Reset() {
	*x = RefreshRuntimeTokenInternalResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RefreshRuntimeTokenInternalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshRuntimeTokenInternalResponse) ProtoMessage() {}

func (x *RefreshRuntimeTokenInternalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshRuntimeTokenInternalResponse.ProtoReflect.Descriptor instead.
func (*RefreshRuntimeTokenInternalResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP(), []int{11}
}

func (x *RefreshRuntimeTokenInternalResponse) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *RefreshRuntimeTokenInternalResponse) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

var File_google_cloud_notebooks_v1_managed_service_proto protoreflect.FileDescriptor

var file_google_cloud_notebooks_v1_managed_service_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x93, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa0, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x08, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x08, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x51,
	0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xde, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x64,
	0x12, 0x41, 0x0a, 0x07, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x73, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x4d, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x4c, 0x0a, 0x12, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0xd5, 0x01, 0x0a, 0x14, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x62, 0x0a, 0x12, 0x61, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x61, 0x63, 0x63, 0x65,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x4d, 0x0a, 0x13,
	0x52, 0x65, 0x73, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb0, 0x01, 0x0a, 0x19,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x05, 0x76, 0x6d, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x76, 0x6d, 0x49,
	0x64, 0x12, 0x3b, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x7c,
	0x0a, 0x22, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x18, 0x0a, 0x05, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x76, 0x6d, 0x49, 0x64, 0x22, 0x8a, 0x01, 0x0a,
	0x23, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x32, 0xc9, 0x10, 0x0a, 0x16, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xae, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x9b, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xd9, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x22, 0x2c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x3a, 0x07, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xc9, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41,
	0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc2, 0x01, 0x0a, 0x0c,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x37, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0xbf, 0x01, 0x0a, 0x0b, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f,
	0x70, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x62,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x6f, 0x70, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xc5, 0x01, 0x0a, 0x0d, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x22, 0x33, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x1c, 0x0a, 0x07,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc2, 0x01, 0x0a, 0x0c, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x37, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x72, 0x65, 0x73, 0x65, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xd4, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xfe, 0x01, 0x0a, 0x1b, 0x52, 0x65, 0x66, 0x72, 0x65,
	0x73, 0x68, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x22, 0x48, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x66, 0x72,
	0x65, 0x73, 0x68, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0a, 0x6e, 0x61, 0x6d,
	0x65, 0x2c, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x1a, 0x4c, 0xca, 0x41, 0x18, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd3, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x15, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_notebooks_v1_managed_service_proto_rawDescOnce sync.Once
	file_google_cloud_notebooks_v1_managed_service_proto_rawDescData = file_google_cloud_notebooks_v1_managed_service_proto_rawDesc
)

func file_google_cloud_notebooks_v1_managed_service_proto_rawDescGZIP() []byte {
	file_google_cloud_notebooks_v1_managed_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_notebooks_v1_managed_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_notebooks_v1_managed_service_proto_rawDescData)
	})
	return file_google_cloud_notebooks_v1_managed_service_proto_rawDescData
}

var file_google_cloud_notebooks_v1_managed_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_notebooks_v1_managed_service_proto_goTypes = []interface{}{
	(*ListRuntimesRequest)(nil),                 // 0: google.cloud.notebooks.v1.ListRuntimesRequest
	(*ListRuntimesResponse)(nil),                // 1: google.cloud.notebooks.v1.ListRuntimesResponse
	(*GetRuntimeRequest)(nil),                   // 2: google.cloud.notebooks.v1.GetRuntimeRequest
	(*CreateRuntimeRequest)(nil),                // 3: google.cloud.notebooks.v1.CreateRuntimeRequest
	(*DeleteRuntimeRequest)(nil),                // 4: google.cloud.notebooks.v1.DeleteRuntimeRequest
	(*StartRuntimeRequest)(nil),                 // 5: google.cloud.notebooks.v1.StartRuntimeRequest
	(*StopRuntimeRequest)(nil),                  // 6: google.cloud.notebooks.v1.StopRuntimeRequest
	(*SwitchRuntimeRequest)(nil),                // 7: google.cloud.notebooks.v1.SwitchRuntimeRequest
	(*ResetRuntimeRequest)(nil),                 // 8: google.cloud.notebooks.v1.ResetRuntimeRequest
	(*ReportRuntimeEventRequest)(nil),           // 9: google.cloud.notebooks.v1.ReportRuntimeEventRequest
	(*RefreshRuntimeTokenInternalRequest)(nil),  // 10: google.cloud.notebooks.v1.RefreshRuntimeTokenInternalRequest
	(*RefreshRuntimeTokenInternalResponse)(nil), // 11: google.cloud.notebooks.v1.RefreshRuntimeTokenInternalResponse
	(*Runtime)(nil),                             // 12: google.cloud.notebooks.v1.Runtime
	(*RuntimeAcceleratorConfig)(nil),            // 13: google.cloud.notebooks.v1.RuntimeAcceleratorConfig
	(*Event)(nil),                               // 14: google.cloud.notebooks.v1.Event
	(*timestamppb.Timestamp)(nil),               // 15: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),               // 16: google.longrunning.Operation
}
var file_google_cloud_notebooks_v1_managed_service_proto_depIdxs = []int32{
	12, // 0: google.cloud.notebooks.v1.ListRuntimesResponse.runtimes:type_name -> google.cloud.notebooks.v1.Runtime
	12, // 1: google.cloud.notebooks.v1.CreateRuntimeRequest.runtime:type_name -> google.cloud.notebooks.v1.Runtime
	13, // 2: google.cloud.notebooks.v1.SwitchRuntimeRequest.accelerator_config:type_name -> google.cloud.notebooks.v1.RuntimeAcceleratorConfig
	14, // 3: google.cloud.notebooks.v1.ReportRuntimeEventRequest.event:type_name -> google.cloud.notebooks.v1.Event
	15, // 4: google.cloud.notebooks.v1.RefreshRuntimeTokenInternalResponse.expire_time:type_name -> google.protobuf.Timestamp
	0,  // 5: google.cloud.notebooks.v1.ManagedNotebookService.ListRuntimes:input_type -> google.cloud.notebooks.v1.ListRuntimesRequest
	2,  // 6: google.cloud.notebooks.v1.ManagedNotebookService.GetRuntime:input_type -> google.cloud.notebooks.v1.GetRuntimeRequest
	3,  // 7: google.cloud.notebooks.v1.ManagedNotebookService.CreateRuntime:input_type -> google.cloud.notebooks.v1.CreateRuntimeRequest
	4,  // 8: google.cloud.notebooks.v1.ManagedNotebookService.DeleteRuntime:input_type -> google.cloud.notebooks.v1.DeleteRuntimeRequest
	5,  // 9: google.cloud.notebooks.v1.ManagedNotebookService.StartRuntime:input_type -> google.cloud.notebooks.v1.StartRuntimeRequest
	6,  // 10: google.cloud.notebooks.v1.ManagedNotebookService.StopRuntime:input_type -> google.cloud.notebooks.v1.StopRuntimeRequest
	7,  // 11: google.cloud.notebooks.v1.ManagedNotebookService.SwitchRuntime:input_type -> google.cloud.notebooks.v1.SwitchRuntimeRequest
	8,  // 12: google.cloud.notebooks.v1.ManagedNotebookService.ResetRuntime:input_type -> google.cloud.notebooks.v1.ResetRuntimeRequest
	9,  // 13: google.cloud.notebooks.v1.ManagedNotebookService.ReportRuntimeEvent:input_type -> google.cloud.notebooks.v1.ReportRuntimeEventRequest
	10, // 14: google.cloud.notebooks.v1.ManagedNotebookService.RefreshRuntimeTokenInternal:input_type -> google.cloud.notebooks.v1.RefreshRuntimeTokenInternalRequest
	1,  // 15: google.cloud.notebooks.v1.ManagedNotebookService.ListRuntimes:output_type -> google.cloud.notebooks.v1.ListRuntimesResponse
	12, // 16: google.cloud.notebooks.v1.ManagedNotebookService.GetRuntime:output_type -> google.cloud.notebooks.v1.Runtime
	16, // 17: google.cloud.notebooks.v1.ManagedNotebookService.CreateRuntime:output_type -> google.longrunning.Operation
	16, // 18: google.cloud.notebooks.v1.ManagedNotebookService.DeleteRuntime:output_type -> google.longrunning.Operation
	16, // 19: google.cloud.notebooks.v1.ManagedNotebookService.StartRuntime:output_type -> google.longrunning.Operation
	16, // 20: google.cloud.notebooks.v1.ManagedNotebookService.StopRuntime:output_type -> google.longrunning.Operation
	16, // 21: google.cloud.notebooks.v1.ManagedNotebookService.SwitchRuntime:output_type -> google.longrunning.Operation
	16, // 22: google.cloud.notebooks.v1.ManagedNotebookService.ResetRuntime:output_type -> google.longrunning.Operation
	16, // 23: google.cloud.notebooks.v1.ManagedNotebookService.ReportRuntimeEvent:output_type -> google.longrunning.Operation
	11, // 24: google.cloud.notebooks.v1.ManagedNotebookService.RefreshRuntimeTokenInternal:output_type -> google.cloud.notebooks.v1.RefreshRuntimeTokenInternalResponse
	15, // [15:25] is the sub-list for method output_type
	5,  // [5:15] is the sub-list for method input_type
	5,  // [5:5] is the sub-list for extension type_name
	5,  // [5:5] is the sub-list for extension extendee
	0,  // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_notebooks_v1_managed_service_proto_init() }
func file_google_cloud_notebooks_v1_managed_service_proto_init() {
	if File_google_cloud_notebooks_v1_managed_service_proto != nil {
		return
	}
	file_google_cloud_notebooks_v1_event_proto_init()
	file_google_cloud_notebooks_v1_runtime_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuntimesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRuntimesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRuntimeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRuntimeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRuntimeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartRuntimeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopRuntimeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SwitchRuntimeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetRuntimeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportRuntimeEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefreshRuntimeTokenInternalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_managed_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RefreshRuntimeTokenInternalResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_notebooks_v1_managed_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_notebooks_v1_managed_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_notebooks_v1_managed_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_notebooks_v1_managed_service_proto_msgTypes,
	}.Build()
	File_google_cloud_notebooks_v1_managed_service_proto = out.File
	file_google_cloud_notebooks_v1_managed_service_proto_rawDesc = nil
	file_google_cloud_notebooks_v1_managed_service_proto_goTypes = nil
	file_google_cloud_notebooks_v1_managed_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ManagedNotebookServiceClient is the client API for ManagedNotebookService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ManagedNotebookServiceClient interface {
	// Lists Runtimes in a given project and location.
	ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error)
	// Gets details of a single Runtime. The location must be a regional endpoint
	// rather than zonal.
	GetRuntime(ctx context.Context, in *GetRuntimeRequest, opts ...grpc.CallOption) (*Runtime, error)
	// Creates a new Runtime in a given project and location.
	CreateRuntime(ctx context.Context, in *CreateRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single Runtime.
	DeleteRuntime(ctx context.Context, in *DeleteRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Starts a Managed Notebook Runtime.
	// Perform "Start" on GPU instances; "Resume" on CPU instances
	// See:
	// https://cloud.google.com/compute/docs/instances/stop-start-instance
	// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
	StartRuntime(ctx context.Context, in *StartRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Stops a Managed Notebook Runtime.
	// Perform "Stop" on GPU instances; "Suspend" on CPU instances
	// See:
	// https://cloud.google.com/compute/docs/instances/stop-start-instance
	// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
	StopRuntime(ctx context.Context, in *StopRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Switch a Managed Notebook Runtime.
	SwitchRuntime(ctx context.Context, in *SwitchRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Resets a Managed Notebook Runtime.
	ResetRuntime(ctx context.Context, in *ResetRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Report and process a runtime event.
	ReportRuntimeEvent(ctx context.Context, in *ReportRuntimeEventRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an access token for the consumer service account that the customer
	// attached to the runtime. Only accessible from the tenant instance.
	RefreshRuntimeTokenInternal(ctx context.Context, in *RefreshRuntimeTokenInternalRequest, opts ...grpc.CallOption) (*RefreshRuntimeTokenInternalResponse, error)
}

type managedNotebookServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewManagedNotebookServiceClient(cc grpc.ClientConnInterface) ManagedNotebookServiceClient {
	return &managedNotebookServiceClient{cc}
}

func (c *managedNotebookServiceClient) ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error) {
	out := new(ListRuntimesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/ListRuntimes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) GetRuntime(ctx context.Context, in *GetRuntimeRequest, opts ...grpc.CallOption) (*Runtime, error) {
	out := new(Runtime)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/GetRuntime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) CreateRuntime(ctx context.Context, in *CreateRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/CreateRuntime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) DeleteRuntime(ctx context.Context, in *DeleteRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/DeleteRuntime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) StartRuntime(ctx context.Context, in *StartRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/StartRuntime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) StopRuntime(ctx context.Context, in *StopRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/StopRuntime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) SwitchRuntime(ctx context.Context, in *SwitchRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/SwitchRuntime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) ResetRuntime(ctx context.Context, in *ResetRuntimeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/ResetRuntime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) ReportRuntimeEvent(ctx context.Context, in *ReportRuntimeEventRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/ReportRuntimeEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) RefreshRuntimeTokenInternal(ctx context.Context, in *RefreshRuntimeTokenInternalRequest, opts ...grpc.CallOption) (*RefreshRuntimeTokenInternalResponse, error) {
	out := new(RefreshRuntimeTokenInternalResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.notebooks.v1.ManagedNotebookService/RefreshRuntimeTokenInternal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagedNotebookServiceServer is the server API for ManagedNotebookService service.
type ManagedNotebookServiceServer interface {
	// Lists Runtimes in a given project and location.
	ListRuntimes(context.Context, *ListRuntimesRequest) (*ListRuntimesResponse, error)
	// Gets details of a single Runtime. The location must be a regional endpoint
	// rather than zonal.
	GetRuntime(context.Context, *GetRuntimeRequest) (*Runtime, error)
	// Creates a new Runtime in a given project and location.
	CreateRuntime(context.Context, *CreateRuntimeRequest) (*longrunning.Operation, error)
	// Deletes a single Runtime.
	DeleteRuntime(context.Context, *DeleteRuntimeRequest) (*longrunning.Operation, error)
	// Starts a Managed Notebook Runtime.
	// Perform "Start" on GPU instances; "Resume" on CPU instances
	// See:
	// https://cloud.google.com/compute/docs/instances/stop-start-instance
	// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
	StartRuntime(context.Context, *StartRuntimeRequest) (*longrunning.Operation, error)
	// Stops a Managed Notebook Runtime.
	// Perform "Stop" on GPU instances; "Suspend" on CPU instances
	// See:
	// https://cloud.google.com/compute/docs/instances/stop-start-instance
	// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
	StopRuntime(context.Context, *StopRuntimeRequest) (*longrunning.Operation, error)
	// Switch a Managed Notebook Runtime.
	SwitchRuntime(context.Context, *SwitchRuntimeRequest) (*longrunning.Operation, error)
	// Resets a Managed Notebook Runtime.
	ResetRuntime(context.Context, *ResetRuntimeRequest) (*longrunning.Operation, error)
	// Report and process a runtime event.
	ReportRuntimeEvent(context.Context, *ReportRuntimeEventRequest) (*longrunning.Operation, error)
	// Gets an access token for the consumer service account that the customer
	// attached to the runtime. Only accessible from the tenant instance.
	RefreshRuntimeTokenInternal(context.Context, *RefreshRuntimeTokenInternalRequest) (*RefreshRuntimeTokenInternalResponse, error)
}

// UnimplementedManagedNotebookServiceServer can be embedded to have forward compatible implementations.
type UnimplementedManagedNotebookServiceServer struct {
}

func (*UnimplementedManagedNotebookServiceServer) ListRuntimes(context.Context, *ListRuntimesRequest) (*ListRuntimesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuntimes not implemented")
}
func (*UnimplementedManagedNotebookServiceServer) GetRuntime(context.Context, *GetRuntimeRequest) (*Runtime, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRuntime not implemented")
}
func (*UnimplementedManagedNotebookServiceServer) CreateRuntime(context.Context, *CreateRuntimeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRuntime not implemented")
}
func (*UnimplementedManagedNotebookServiceServer) DeleteRuntime(context.Context, *DeleteRuntimeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRuntime not implemented")
}
func (*UnimplementedManagedNotebookServiceServer) StartRuntime(context.Context, *StartRuntimeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartRuntime not implemented")
}
func (*UnimplementedManagedNotebookServiceServer) StopRuntime(context.Context, *StopRuntimeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopRuntime not implemented")
}
func (*UnimplementedManagedNotebookServiceServer) SwitchRuntime(context.Context, *SwitchRuntimeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SwitchRuntime not implemented")
}
func (*UnimplementedManagedNotebookServiceServer) ResetRuntime(context.Context, *ResetRuntimeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetRuntime not implemented")
}
func (*UnimplementedManagedNotebookServiceServer) ReportRuntimeEvent(context.Context, *ReportRuntimeEventRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportRuntimeEvent not implemented")
}
func (*UnimplementedManagedNotebookServiceServer) RefreshRuntimeTokenInternal(context.Context, *RefreshRuntimeTokenInternalRequest) (*RefreshRuntimeTokenInternalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefreshRuntimeTokenInternal not implemented")
}

func RegisterManagedNotebookServiceServer(s *grpc.Server, srv ManagedNotebookServiceServer) {
	s.RegisterService(&_ManagedNotebookService_serviceDesc, srv)
}

func _ManagedNotebookService_ListRuntimes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRuntimesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).ListRuntimes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/ListRuntimes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).ListRuntimes(ctx, req.(*ListRuntimesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_GetRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).GetRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/GetRuntime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).GetRuntime(ctx, req.(*GetRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_CreateRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).CreateRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/CreateRuntime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).CreateRuntime(ctx, req.(*CreateRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_DeleteRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).DeleteRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/DeleteRuntime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).DeleteRuntime(ctx, req.(*DeleteRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_StartRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).StartRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/StartRuntime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).StartRuntime(ctx, req.(*StartRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_StopRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).StopRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/StopRuntime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).StopRuntime(ctx, req.(*StopRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_SwitchRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SwitchRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).SwitchRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/SwitchRuntime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).SwitchRuntime(ctx, req.(*SwitchRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_ResetRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).ResetRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/ResetRuntime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).ResetRuntime(ctx, req.(*ResetRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_ReportRuntimeEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportRuntimeEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).ReportRuntimeEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/ReportRuntimeEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).ReportRuntimeEvent(ctx, req.(*ReportRuntimeEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_RefreshRuntimeTokenInternal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefreshRuntimeTokenInternalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).RefreshRuntimeTokenInternal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.notebooks.v1.ManagedNotebookService/RefreshRuntimeTokenInternal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).RefreshRuntimeTokenInternal(ctx, req.(*RefreshRuntimeTokenInternalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ManagedNotebookService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.notebooks.v1.ManagedNotebookService",
	HandlerType: (*ManagedNotebookServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRuntimes",
			Handler:    _ManagedNotebookService_ListRuntimes_Handler,
		},
		{
			MethodName: "GetRuntime",
			Handler:    _ManagedNotebookService_GetRuntime_Handler,
		},
		{
			MethodName: "CreateRuntime",
			Handler:    _ManagedNotebookService_CreateRuntime_Handler,
		},
		{
			MethodName: "DeleteRuntime",
			Handler:    _ManagedNotebookService_DeleteRuntime_Handler,
		},
		{
			MethodName: "StartRuntime",
			Handler:    _ManagedNotebookService_StartRuntime_Handler,
		},
		{
			MethodName: "StopRuntime",
			Handler:    _ManagedNotebookService_StopRuntime_Handler,
		},
		{
			MethodName: "SwitchRuntime",
			Handler:    _ManagedNotebookService_SwitchRuntime_Handler,
		},
		{
			MethodName: "ResetRuntime",
			Handler:    _ManagedNotebookService_ResetRuntime_Handler,
		},
		{
			MethodName: "ReportRuntimeEvent",
			Handler:    _ManagedNotebookService_ReportRuntimeEvent_Handler,
		},
		{
			MethodName: "RefreshRuntimeTokenInternal",
			Handler:    _ManagedNotebookService_RefreshRuntimeTokenInternal_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/notebooks/v1/managed_service.proto",
}
