SHELL	=	/bin/sh

##############################################################################
# MorphOS / LinuxPPC
##############################################################################

CC 		=	@gcc
AS 		=	@as
LD 		=	@ld
AR		=	@ar
RANLIB		=	@ranlib
STRIP		=	@strip
DUMP		=	@objdump

CODETYPE	=	PPC

WARNINGS	=	-Wall -Wno-parentheses -Wno-unused

CPU		=	-mcpu=750

OPTIONS		=	-mregnames -mmultiple -mno-prototype -pipe

OPTIMIZE	=	-O2 -fomit-frame-pointer

INCLUDES	=	

DEBUG		=	-g

LFLAGS		=	

CFLAGS	=	$(WARNINGS) $(OPTIMIZE) $(DEBUG) $(CPU) $(OPTIONS) $(INCLUDES) -I.

SFLAGS	=	--remove-section .comment

DFLAGS	=	--syms --reloc --disassemble-all

IFLAGS	=	-kr -cbi0 -bl -bli0 -ncdw -cli4 -ts4 -nbbo -l512 -nce -i4 -ts4 \
		-npcs -nsaf -nsai -nsaw -nbsOC -bls

##############################################################################

DEFINES	=	-D$(CODETYPE) -D__DATE=\"`date +%d.%m.%Y`\"

##############################################################################

MAKE			=	make -s

CD			=	@cd
CP			=	@cp
RM			=	@rm
ECHO			=	@echo
MKDIR			=	@mkdir
LN			=	@ln
SED			=	@sed
IDENT			=	@indent

##############################################################################

BINDIR		=	$(TOPLEVEL)/bin
SRCDIR		=	$(TOPLEVEL)/src
DOCDIR		=	$(TOPLEVEL)/doc
EXAMPLESDIR	=	$(TOPLEVEL)/examples
TOOLSDIR	=	$(TOPLEVEL)/tools

##############################################################################

OBJDIR		=	.objs

##############################################################################

STRIP_RULE	=	$(TOPLEVEL)/rules_strip.mk
DUMP_RULE	=	$(TOPLEVEL)/rules_dump.mk

##############################################################################

FIXDEPS		=	$(TOOLSDIR)/fixdeps.sed

##############################################################################
