/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.IOException;
import java.util.EnumSet;
import org.jruby.EvalType;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.persistence.IRPersistenceValues;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;

public class IRReader
implements IRPersistenceValues {
    public static IRScope load(IRManager manager, IRReaderDecoder file2) throws IOException {
        int version;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("IRReader.load");
        }
        if ((version = file2.decodeIntRaw()) != 2) {
            throw new IOException("Trying to read incompatible persistence format (version found: " + version + ", version expected: " + 2);
        }
        int headersOffset = file2.decodeIntRaw();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("header_offset = " + headersOffset);
        }
        file2.seek(headersOffset);
        int scopesToRead = file2.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("load: scopes to read = " + scopesToRead);
        }
        IRScope firstScope = null;
        for (int i2 = 0; i2 < scopesToRead; ++i2) {
            IRScopeType type2 = file2.decodeIRScopeType();
            int line = file2.decodeInt();
            int tempVarsCount = file2.decodeInt();
            int nextLabelInt = file2.decodeInt();
            IRScope scope = IRReader.decodeScopeHeader(manager, file2, type2, line);
            scope.setNextLabelIndex(nextLabelInt);
            EnumSet<IRFlags> flags2 = file2.decodeIRFlags();
            if (file2.decodeBoolean()) {
                scope.setHasBreakInstructions();
            }
            if (file2.decodeBoolean()) {
                scope.setHasLoops();
            }
            if (file2.decodeBoolean()) {
                scope.setHasNonLocalReturns();
            }
            if (file2.decodeBoolean()) {
                scope.setReceivesClosureArg();
            }
            if (file2.decodeBoolean()) {
                scope.setReceivesKeywordArgs();
            }
            if (file2.decodeBoolean()) {
                scope.setAccessesParentsLocalVariables();
            }
            if (file2.decodeBoolean()) {
                scope.setIsMaybeUsingRefinements();
            }
            if (file2.decodeBoolean()) {
                scope.setCanCaptureCallersBinding();
            }
            if (file2.decodeBoolean()) {
                scope.setCanReceiveBreaks();
            }
            if (file2.decodeBoolean()) {
                scope.setCanReceiveNonlocalReturns();
            }
            if (file2.decodeBoolean()) {
                scope.setUsesZSuper();
            }
            if (file2.decodeBoolean()) {
                scope.setUsesEval();
            }
            scope.setCoverageMode(file2.decodeInt());
            if (firstScope == null) {
                firstScope = scope;
            }
            int instructionsOffset = file2.decodeInt();
            int poolOffset = file2.decodeInt();
            scope.allocateInterpreterContext(() -> file2.dup().decodeInstructionsAt(scope, poolOffset, instructionsOffset), tempVarsCount, flags2);
        }
        return firstScope;
    }

    private static IRScope decodeScopeHeader(IRManager manager, IRReaderDecoder decoder, IRScopeType type2, int line) {
        StaticScope parentScope;
        StaticScope staticScope;
        IRScope scope;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("DECODING SCOPE HEADER");
        }
        boolean isEND = false;
        if (type2 == IRScopeType.CLOSURE) {
            isEND = decoder.decodeBoolean();
            if (RubyInstanceConfig.IR_READING_DEBUG) {
                System.out.println("decodeScopeHeader: cl is end = " + isEND);
            }
        }
        Signature signature = type2 == IRScopeType.CLOSURE || type2 == IRScopeType.FOR ? Signature.decode(decoder.decodeLong()) : Signature.OPTIONAL;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeScopeHeader: signature =  " + signature);
        }
        String file2 = null;
        ByteList name2 = null;
        IRScope parent = null;
        if (type2 == IRScopeType.SCRIPT_BODY) {
            file2 = decoder.getFilename();
            if (RubyInstanceConfig.IR_READING_DEBUG) {
                System.out.println("decodeScopeHeader: script file = " + file2);
            }
        } else {
            name2 = decoder.decodeByteList();
            if (RubyInstanceConfig.IR_READING_DEBUG) {
                System.out.println("decodeScopeHeader: name = " + name2);
            }
            parent = decoder.decodeScope();
            if (RubyInstanceConfig.IR_READING_DEBUG) {
                System.out.println("decodeScopeHeader: parent = " + parent);
            }
        }
        if ((scope = IRReader.createScope(manager, type2, name2, file2, line, parent, signature, staticScope = IRReader.decodeStaticScope(decoder, parentScope = parent == null ? null : parent.getStaticScope()))) instanceof IRClosure && isEND) {
            ((IRClosure)scope).setIsEND();
        }
        decoder.addScope(scope);
        return scope;
    }

    private static StaticScope decodeStaticScope(IRReaderDecoder decoder, StaticScope parentScope) {
        StaticScope.Type type2 = decoder.decodeStaticScopeType();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeStaticScope: type = " + (Object)((Object)type2));
        }
        String[] ids = decoder.decodeStringArray();
        int firstKeywordIndex = decoder.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeStaticScope: keyword index = " + firstKeywordIndex);
        }
        StaticScope scope = StaticScopeFactory.newStaticScope(parentScope, type2, decoder.getFilename(), ids, firstKeywordIndex);
        Signature signature = decoder.decodeSignature();
        scope.setSignature(signature);
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decodeStaticScope: signature = " + signature);
        }
        return scope;
    }

    public static IRScope createScope(IRManager manager, IRScopeType type2, ByteList byteName, String file2, int line, IRScope lexicalParent, Signature signature, StaticScope staticScope) {
        switch (type2) {
            case CLASS_BODY: {
                return new IRClassBody(manager, lexicalParent, byteName, line, staticScope, false);
            }
            case METACLASS_BODY: {
                return new IRMetaClassBody(manager, lexicalParent, manager.getMetaClassName().getBytes(), line, staticScope);
            }
            case INSTANCE_METHOD: {
                return new IRMethod(manager, lexicalParent, null, byteName, true, line, staticScope, 0);
            }
            case CLASS_METHOD: {
                return new IRMethod(manager, lexicalParent, null, byteName, false, line, staticScope, 0);
            }
            case MODULE_BODY: {
                return new IRModuleBody(manager, lexicalParent, byteName, line, staticScope, false);
            }
            case SCRIPT_BODY: {
                return new IRScriptBody(manager, file2, staticScope);
            }
            case FOR: {
                return new IRFor(manager, lexicalParent, line, staticScope, signature);
            }
            case CLOSURE: {
                return new IRClosure(manager, lexicalParent, line, staticScope, signature);
            }
            case EVAL_SCRIPT: {
                return new IREvalScript(manager, lexicalParent, lexicalParent.getFile(), line, staticScope, EvalType.NONE);
            }
        }
        throw new RuntimeException("No such scope type: " + (Object)((Object)type2));
    }
}

