/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.internal.ActionMessages;
import org.xmind.ui.brainstorm.actions.UndoRedoAction;

public class UndoAction
extends UndoRedoAction {
    public UndoAction(IGraphicalViewer viewer) {
        super(viewer, "undo");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ActionFactory.IWorkbenchAction action = ActionFactory.UNDO.create(window);
        this.setId(action.getId());
        this.setText(action.getText());
        this.setImageDescriptor(action.getImageDescriptor());
        this.setDisabledImageDescriptor(action.getDisabledImageDescriptor());
        this.setActionDefinitionId("org.eclipse.ui.edit.undo");
    }

    public void run() {
        ICommandStack undoStack = this.getCommandStack();
        if (undoStack == null) {
            return;
        }
        if (undoStack.canUndo()) {
            undoStack.undo();
        }
    }

    protected void update() {
        ICommandStack cs = this.getCommandStack();
        boolean canUndo = cs != null && cs.canUndo();
        this.setEnabled(canUndo);
        String label = null;
        if (canUndo && cs != null) {
            label = cs.getUndoLabel();
        }
        if (label == null) {
            this.setText(ActionMessages.UndoText);
            this.setToolTipText(ActionMessages.UndoTooltip);
        } else {
            this.setText(NLS.bind((String)ActionMessages.UndoTextFormat, (Object)label));
            this.setToolTipText(NLS.bind((String)ActionMessages.UndoTooltipFormat, (Object)label));
        }
    }
}

