/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ITopic;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.ideafactory.IdeaFactoryViewer;
import org.xmind.ui.internal.tools.TopicMoveTool;

public class BrainstormTopicMoveTool
extends TopicMoveTool {
    private boolean running = false;
    private boolean isDraggingToIdeas;
    private IdeaFactoryViewer currentViewer;

    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        IPreferenceStore prefStore = MindMapUIPlugin.getDefault().getPreferenceStore();
        boolean status = prefStore.getBoolean("manualLayoutAllowed");
        this.getStatus().setStatus(4096, status);
    }

    protected void start() {
        super.start();
        this.running = true;
    }

    protected void suspend() {
        super.suspend();
        this.running = false;
    }

    protected void onMoving(Point currentPos, MouseDragEvent me) {
        Point toDisplay = this.getTargetViewer().computeToDisplay(currentPos, true);
        Control control = (Control)this.getTargetViewer().getProperties().get("ideaFactoryWrapperControl");
        if (control != null && !control.isDisposed() && control.isVisible() && control.getBounds().contains(toDisplay.x, toDisplay.y) && this.canDrag()) {
            this.dragToIdeas(toDisplay);
        } else {
            if (!this.running) {
                this.start();
            }
            super.onMoving(currentPos, me);
        }
    }

    private void dragToIdeas(Point toDisplay) {
        if (this.running) {
            this.suspend();
        }
        if (!this.isDraggingToIdeas) {
            this.isDraggingToIdeas = true;
        }
        IdeaFactoryViewer viewer = null;
        List viewers = (List)this.getTargetViewer().getProperties().get("ideaFactoryViewers");
        if (viewers != null) {
            for (IdeaFactoryViewer viewer2 : viewers) {
                Control control = viewer2.getControl();
                Rectangle bounds = control.getBounds();
                org.eclipse.swt.graphics.Point topLeft = control.getParent().toDisplay(bounds.x, bounds.y);
                bounds.x = topLeft.x;
                bounds.y = topLeft.y;
                if (!bounds.contains(toDisplay.x, toDisplay.y)) continue;
                viewer = viewer2;
                viewer.getIdeaDropTargetHandler().dragOver(new org.eclipse.swt.graphics.Point(toDisplay.x, toDisplay.y));
                break;
            }
        }
        if (viewer != this.currentViewer) {
            if (this.currentViewer != null) {
                this.currentViewer.getIdeaDropTargetHandler().dragLeave();
            }
            this.currentViewer = viewer;
        }
    }

    private boolean canDrag() {
        ISelection selection = this.getTargetViewer().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        Object[] sources = ((IStructuredSelection)selection).toArray();
        if (sources.length == 0) {
            return false;
        }
        Object[] objectArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            Object source = objectArray[n2];
            if (!(source instanceof ITopic)) {
                return false;
            }
            if (source instanceof ITopic && ((ITopic)source).isRoot()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean handleMouseUp(MouseEvent me) {
        Point toDisplay = this.getTargetViewer().computeToDisplay(me.cursorLocation, true);
        Control control = (Control)this.getTargetViewer().getProperties().get("ideaFactoryWrapperControl");
        if (control != null && !control.isDisposed() && control.isVisible() && control.getBounds().contains(toDisplay.x, toDisplay.y) && this.canDrag()) {
            if (this.isDraggingToIdeas && this.currentViewer != null) {
                Object[] sources = ((IStructuredSelection)this.getTargetViewer().getSelection()).toArray();
                this.currentViewer.getIdeaDropTargetHandler().dropTopics(sources);
            }
            this.cancel();
            return true;
        }
        return super.handleMouseUp(me);
    }

    public void cancel() {
        if (this.currentViewer != null && !this.currentViewer.getControl().isDisposed() && this.currentViewer.getControl().isVisible()) {
            this.currentViewer.getIdeaDropTargetHandler().dragLeave();
        }
        super.cancel();
    }
}

