/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.decorations.AbstractTopicDecoration;
import org.xmind.ui.internal.svgsupport.SvgPathParser;

public class CloudTopicDecoration
extends AbstractTopicDecoration {
    private static final float scaleLeft = 0.17f;
    private static final float scaleRight = 0.16f;
    private static final float scaleTop = 0.22f;
    private static final float scaleBottom = 0.27f;
    private static final float RATIO = 2.5f;
    private String svgPath;

    public CloudTopicDecoration() {
    }

    public CloudTopicDecoration(String id) {
        super(id);
    }

    public CloudTopicDecoration(String id, String svgPath) {
        super(id);
        this.svgPath = svgPath;
    }

    protected void sketch(IFigure figure, org.xmind.gef.draw2d.graphics.Path shape, Rectangle box, int purpose) {
        org.xmind.gef.draw2d.graphics.Path path = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        SvgPathParser parser = SvgPathParser.getInstance();
        float halfLineWidth = (float)this.getLineWidth() * 0.5f;
        if (purpose == 3) {
            parser.parseSvgPath(path, (float)box.getCenter().x - halfLineWidth, (float)box.getCenter().y + halfLineWidth, box.width + this.getLineWidth(), box.height + this.getLineWidth(), this.svgPath);
        } else {
            parser.parseSvgPath(path, box.getCenter().x + 1, box.getCenter().y + 1, box.width, box.height, this.svgPath);
        }
        shape.addPath((Path)path);
        path.close();
    }

    public PrecisionPoint getAnchorLocation(IFigure figure, double refX, double refY, double expansion) {
        float scaleWidth = 0.66999996f;
        float scaleHeight = 0.51f;
        Rectangle bounds = figure.getBounds();
        Point tf = bounds.getTopLeft().getTranslated((double)((float)bounds.width * 0.17f), (double)((float)bounds.height * 0.22f));
        Rectangle area = new Rectangle(tf.x, tf.y, (int)((float)bounds.width * scaleWidth), (int)((float)bounds.height * scaleHeight));
        PrecisionPoint p1 = Geometry.getChopBoxLocation((double)refX, (double)refY, (Rectangle)area, (double)expansion);
        PrecisionPoint p2 = Geometry.getChopBoxLocation((double)refX, (double)refY, (Rectangle)this.getOutlineBox(figure), (double)expansion);
        return this.calcAnchorLocation(figure, p1, p2);
    }

    private PrecisionPoint calcAnchorLocation(IFigure figure, PrecisionPoint p1, PrecisionPoint p2) {
        double d = p1.getDistance(p2);
        int n = this.getLineWidth() == 0 ? 1 : this.getLineWidth();
        if (d < (double)n) {
            return p2;
        }
        PrecisionPoint p3 = new PrecisionPoint((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0);
        if (this.containsPoint(figure, (float)p3.x, (float)p3.y)) {
            return this.calcAnchorLocation(figure, p3, p2);
        }
        return this.calcAnchorLocation(figure, p1, p3);
    }

    private boolean containsPoint(IFigure figure, float x, float y) {
        this.checkValidation(figure);
        GC gc = GraphicsUtils.getAdvanced().getGC();
        gc.setLineWidth(this.getCheckingLineWidth());
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        this.sketch(figure, shape, this.getOutlineBox(figure), 1);
        boolean ret = shape.contains(x, y, gc, false);
        shape.close();
        shape.dispose();
        return ret;
    }

    @Override
    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        float scaleWidth = 0.66999996f;
        float scaleHeight = 0.51f;
        Insets insets = new Insets((int)((float)(height + this.getTopMargin() + this.getLineWidth()) / scaleHeight * 0.22f), (int)((float)(width + this.getLeftMargin() + this.getLineWidth()) / scaleWidth * 0.17f), (int)((float)(height + this.getBottomMargin() + this.getLineWidth()) / scaleHeight * 0.27f), (int)((float)(width + this.getRightMargin() + this.getLineWidth()) / scaleWidth * 0.16f));
        PrecisionDimension dimension = this.expandWHitAsRatio(new PrecisionDimension((double)(width + insets.left + insets.right), (double)(height + insets.top + insets.bottom)));
        Insets inset = new Insets();
        inset.top = (int)((float)(dimension.height - height) * 0.22f / 0.49f);
        inset.left = (int)((float)(dimension.width - width) * 0.17f / 0.32999998f);
        inset.bottom = (int)((float)(dimension.height - height) * 0.27f / 0.49f);
        inset.right = (int)((float)(dimension.width - width) * 0.16f / 0.32999998f);
        return inset;
    }

    private PrecisionDimension expandWHitAsRatio(PrecisionDimension whitDimension) {
        PrecisionDimension dimension = whitDimension;
        if ((float)whitDimension.width > (float)whitDimension.height * 2.5f) {
            dimension.height = (int)Math.ceil((float)whitDimension.width / 2.5f);
            dimension.width = (int)((float)dimension.height * 2.5f);
        } else if ((float)whitDimension.width < (float)whitDimension.height * 2.5f) {
            dimension.width = (int)Math.ceil((float)whitDimension.height * 2.5f);
        }
        return dimension;
    }
}

