/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IDeserializer;
import org.xmind.core.IFileEntry;
import org.xmind.core.IRevisionRepository;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.internal.AbstractSerializingBase;
import org.xmind.core.internal.compatibility.Compatibility;
import org.xmind.core.internal.dom.CommentManagerImpl;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.MarkerSheetBuilderImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.StyleSheetBuilderImpl;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.dom.WorkbookExtensionManagerImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookMarkerResourceProvider;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.CoreIOException;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IStorage;
import org.xmind.core.io.InvalidChecksumException;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.IProgressReporter;
import org.xml.sax.SAXException;

public class DeserializerImpl
extends AbstractSerializingBase
implements IDeserializer {
    private WorkbookImpl workbook = null;
    private IStorage storage = new ByteArrayStorage();
    private IInputSource inputSource = null;
    private InputStream inputStream = null;
    private boolean usesWorkbookStorageAsInputSource = false;
    private ManifestImpl manifest = null;
    private final Map<String, Document> loadedDocuments = new HashMap<String, Document>();

    public IWorkbook getWorkbook() {
        return this.workbook;
    }

    protected void setWorkbook(WorkbookImpl workbook) {
        this.workbook = workbook;
    }

    public void setWorkbookStorage(IStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException("storage is null");
        }
        this.storage = storage;
    }

    public IStorage getWorkbookStorage() {
        return this.storage;
    }

    public void setInputSource(IInputSource source) {
        if (source == null) {
            throw new IllegalArgumentException("input source is null");
        }
        this.inputSource = source;
        this.inputStream = null;
        this.usesWorkbookStorageAsInputSource = false;
    }

    public void setInputStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        this.inputStream = stream;
        this.inputSource = null;
        this.usesWorkbookStorageAsInputSource = false;
    }

    public void setWorkbookStorageAsInputSource() {
        this.usesWorkbookStorageAsInputSource = true;
        this.inputSource = null;
        this.inputStream = null;
    }

    public boolean hasInputSource() {
        return this.inputSource != null || this.inputStream != null || this.usesWorkbookStorageAsInputSource;
    }

    public void deserializeManifest(IProgressReporter reporter) throws IOException, CoreException, IllegalStateException {
        if (this.inputStream != null) {
            ZipInputStream zin = new ZipInputStream(this.inputStream);
            try {
                FileUtils.extractZipFile(zin, this.storage.getOutputTarget());
            }
            finally {
                zin.close();
            }
        } else if (this.inputSource != null) {
            FileUtils.transfer(this.inputSource, this.storage.getOutputTarget());
        } else if (!this.usesWorkbookStorageAsInputSource) {
            throw new IllegalStateException("no input source available");
        }
        Document manifestDoc = this.forceLoadDocumentFromEntry("META-INF/manifest.xml");
        this.manifest = new ManifestImpl(manifestDoc, this.storage);
        this.manifest.setStreamNormalizer(this.getEntryStreamNormalizer());
    }

    public void deserialize(IProgressReporter reporter) throws IOException, CoreException, IllegalStateException {
        WorkbookImpl compatibleWorkbook;
        if (this.manifest == null) {
            this.deserializeManifest(reporter);
        }
        if ((compatibleWorkbook = Compatibility.loadCompatibleWorkbook(this)) != null) {
            this.setWorkbook(compatibleWorkbook);
            return;
        }
        try {
            this.setWorkbook(this.loadWorkbook());
        }
        catch (InvalidChecksumException e) {
            throw new CoreException(17, (Throwable)e);
        }
        catch (CoreIOException e) {
            CoreException ce = e.getCoreException();
            throw new CoreException(ce.getType(), ce.getCodeInfo(), e);
        }
    }

    private WorkbookImpl loadWorkbook() throws IOException, CoreException {
        Document commentManagerDoc;
        IWorkbookExtensionManager m;
        Document markerSheetDoc;
        Document workbookDoc = this.forceLoadDocumentFromEntry("content.xml");
        WorkbookImpl workbook = new WorkbookImpl(workbookDoc, this.manifest);
        Document metaDoc = this.forceLoadDocumentFromEntry("meta.xml");
        MetaImpl meta = new MetaImpl(metaDoc);
        workbook.setMeta(meta);
        if (meta.getValue("Create/Time") == null) {
            meta.setValue("Create/Time", NumberUtils.formatDate(System.currentTimeMillis()));
        }
        meta.setValue("Creator/Name", this.getCreatorName());
        meta.setValue("Creator/Version", this.getCreatorVersion());
        Document styleSheetDoc = this.loadDocumentFromEntry("styles.xml");
        if (styleSheetDoc != null) {
            StyleSheetImpl styleSheet = ((StyleSheetBuilderImpl)Core.getStyleSheetBuilder()).createStyleSheet(styleSheetDoc);
            styleSheet.setManifest(this.manifest);
            workbook.setStyleSheet(styleSheet);
        }
        if ((markerSheetDoc = this.loadDocumentFromEntry("markers/markerSheet.xml")) != null) {
            MarkerSheetImpl markerSheet = ((MarkerSheetBuilderImpl)Core.getMarkerSheetBuilder()).createMarkerSheet(markerSheetDoc, new WorkbookMarkerResourceProvider(workbook));
            markerSheet.setManifest(this.manifest);
            workbook.setMarkerSheet(markerSheet);
        }
        if ((m = workbook.getAdapter(IWorkbookExtensionManager.class)) instanceof WorkbookExtensionManagerImpl) {
            WorkbookExtensionManagerImpl extManager = (WorkbookExtensionManagerImpl)m;
            for (String provider : extManager.getProviders()) {
                Document extDoc = this.loadDocumentFromEntry("extensions/" + provider + ".xml");
                if (extDoc == null) continue;
                extManager.createExtension(provider, extDoc);
            }
        }
        if ((commentManagerDoc = this.loadDocumentFromEntry("comments.xml")) != null) {
            CommentManagerImpl commentManager = new CommentManagerImpl(workbook, commentManagerDoc);
            workbook.setCommentManager(commentManager);
        }
        for (ISheet sheet : workbook.getSheets()) {
            ((SheetImpl)sheet).addNotify(workbook);
        }
        IRevisionRepository revisionRepository = workbook.getRevisionRepository();
        for (String resourceId : revisionRepository.getRegisteredResourceIds()) {
            revisionRepository.getRegisteredRevisionManager(resourceId);
        }
        Iterator<IFileEntry> it = this.manifest.iterFileEntries();
        while (it.hasNext()) {
            IFileEntry e = it.next();
            if (e.isDirectory() || !e.canRead()) continue;
            InputStream in = e.openInputStream();
            byte[] b = new byte[1024];
            while (in.read(b) != -1) {
            }
        }
        return workbook;
    }

    protected InputStream openEntryInputStream(String entryPath) throws IOException, CoreException {
        IInputSource source;
        IFileEntry entry;
        if (this.manifest == null && this.storage == null) {
            throw new IllegalStateException("No manifest or input source available");
        }
        if (this.manifest != null && (entry = this.manifest.getFileEntry(entryPath)) != null) {
            if (!entry.canRead()) {
                return null;
            }
            return entry.openInputStream();
        }
        if (this.storage != null && (source = this.storage.getInputSource()) != null && source.hasEntry(entryPath) && source.isEntryAvailable(entryPath)) {
            return source.openEntryStream(entryPath);
        }
        return null;
    }

    protected Document loadDocumentFromEntry(String entryPath) throws IOException, CoreException {
        Document document;
        Document cache = this.loadedDocuments.get(entryPath);
        if (cache != null) {
            return cache;
        }
        InputStream stream = this.openEntryInputStream(entryPath);
        if (stream == null) {
            return null;
        }
        try {
            try {
                document = this.loadDocumentFromStream(stream);
            }
            catch (CoreIOException e) {
                CoreException ce = e.getCoreException();
                throw new CoreException(ce.getType(), ce.getCodeInfo(), e);
            }
            catch (IOException e) {
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
            catch (CoreException e) {
                if (e.getType() == 100) {
                    throw e;
                }
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
            catch (Error e) {
                if (this.hasEncryptionData(entryPath)) {
                    throw new CoreException(17, (Throwable)e);
                }
                throw e;
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        if (document != null) {
            this.loadedDocuments.put(entryPath, document);
        }
        return document;
    }

    protected Document loadDocumentFromStream(InputStream stream) throws IOException, CoreException {
        try {
            DocumentBuilder builder;
            try {
                builder = DOMUtils.getDefaultDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new CoreException(12, (Throwable)e);
            }
            Document document = builder.parse(stream);
            return document;
        }
        catch (SAXException e) {
            throw new CoreException(13, (Throwable)e);
        }
        finally {
            stream.close();
        }
    }

    protected Document createDocument() throws CoreException {
        DocumentBuilder builder;
        try {
            builder = DOMUtils.getDefaultDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(12, (Throwable)e);
        }
        return builder.newDocument();
    }

    protected Document forceLoadDocumentFromEntry(String entryPath) throws CoreException {
        Document document;
        try {
            document = this.loadDocumentFromEntry(entryPath);
        }
        catch (IOException iOException) {
            document = null;
        }
        if (document == null) {
            document = this.createDocument();
            this.loadedDocuments.put(entryPath, document);
        }
        return document;
    }

    public ManifestImpl getManifest() {
        return this.manifest;
    }

    private boolean hasEncryptionData(String entryPath) {
        if (this.manifest != null) {
            IFileEntry entry = this.manifest.getFileEntry(entryPath);
            return entry != null && entry.getEncryptionData() != null;
        }
        return false;
    }
}

