/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.ICommentManager;
import org.xmind.core.IEntryStreamNormalizer;
import org.xmind.core.IFileEntry;
import org.xmind.core.IRevisionManager;
import org.xmind.core.IRevisionRepository;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.internal.AbstractSerializingBase;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.zip.ZipStreamOutputTarget;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.IProgressReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializerImpl
extends AbstractSerializingBase
implements ISerializer {
    private IWorkbook workbook = null;
    private IOutputTarget outputTarget = null;
    private final Set<String> encryptionIgnoredEntries = new HashSet<String>();
    private String[] preferredEncryptionIgnoredEntries = null;
    private ZipOutputStream intermediateOutputStream = null;
    private boolean compressed = false;
    private boolean usesWorkbookStorageAsOutputTarget = false;
    private ManifestImpl manifest = null;
    private ManifestImpl tempManifest = null;
    private final Set<String> serializedEntryPaths = new HashSet<String>();

    @Override
    public IWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public void setWorkbook(IWorkbook workbook) {
        if (workbook == null) {
            throw new IllegalArgumentException("Workbook is null");
        }
        if (!(workbook instanceof WorkbookImpl)) {
            throw new IllegalArgumentException("Can't serialize this workbook");
        }
        IStorage storage = null;
        if (this.usesWorkbookStorageAsOutputTarget && (storage = workbook.getAdapter(IStorage.class)) == null) {
            throw new IllegalArgumentException("No workbook storage available");
        }
        this.workbook = workbook;
        if (storage != null) {
            this.doSetOutputTarget(storage.getOutputTarget());
        }
    }

    protected IOutputTarget getOutputTarget() {
        return this.outputTarget;
    }

    protected void doSetOutputTarget(IOutputTarget target) {
        this.outputTarget = target;
    }

    @Override
    public boolean hasOutputTarget() {
        return this.outputTarget != null;
    }

    @Override
    public void setOutputTarget(IOutputTarget target) {
        if (target == null) {
            throw new IllegalArgumentException("output target is null");
        }
        this.doSetOutputTarget(target);
        this.intermediateOutputStream = null;
        this.usesWorkbookStorageAsOutputTarget = false;
    }

    @Override
    public void setOutputStream(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        this.intermediateOutputStream = new ZipOutputStream(stream);
        this.doSetOutputTarget(new ZipStreamOutputTarget(this.intermediateOutputStream, this.compressed));
        this.usesWorkbookStorageAsOutputTarget = false;
    }

    @Override
    public void setWorkbookStorageAsOutputTarget() {
        if (this.getWorkbook() != null) {
            IStorage storage = this.getWorkbook().getAdapter(IStorage.class);
            if (storage == null) {
                throw new IllegalArgumentException("no workbook storage available");
            }
            this.doSetOutputTarget(storage.getOutputTarget());
        } else {
            this.doSetOutputTarget(new ByteArrayStorage().getOutputTarget());
        }
        this.usesWorkbookStorageAsOutputTarget = true;
        this.intermediateOutputStream = null;
    }

    @Override
    public String[] getEncryptionIgnoredEntries() {
        return this.preferredEncryptionIgnoredEntries;
    }

    @Override
    public void setEncryptionIgnoredEntries(String[] entryPaths) {
        this.preferredEncryptionIgnoredEntries = entryPaths;
        this.encryptionIgnoredEntries.clear();
        this.collectDefaultEncryptionIgnoredEntries(this.encryptionIgnoredEntries);
        if (entryPaths != null) {
            this.encryptionIgnoredEntries.addAll(Arrays.asList(entryPaths));
        }
    }

    protected boolean isEntryEncryptionIgnored(String entryPath) {
        return this.encryptionIgnoredEntries.contains(entryPath);
    }

    protected void collectDefaultEncryptionIgnoredEntries(Set<String> entryPaths) {
        entryPaths.add("META-INF/manifest.xml");
    }

    @Override
    public void serialize(IProgressReporter reporter) throws IOException, CoreException, IllegalStateException {
        String creatorVersion;
        boolean normalizerChanged;
        WorkbookImpl workbook = (WorkbookImpl)this.getWorkbook();
        if (workbook == null) {
            throw new IllegalStateException("no workbook to serialize");
        }
        if (!this.hasOutputTarget()) {
            throw new IllegalStateException("no output target specified");
        }
        this.manifest = workbook.getManifest();
        IEntryStreamNormalizer oldNormalizer = this.manifest.getStreamNormalizer();
        IEntryStreamNormalizer newNormalizer = this.getEntryStreamNormalizer();
        boolean bl = normalizerChanged = newNormalizer != null && !newNormalizer.equals(oldNormalizer);
        if (this.usesWorkbookStorageAsOutputTarget) {
            this.tempManifest = this.manifest;
            if (normalizerChanged) {
                this.tempManifest.setStreamNormalizer(newNormalizer);
            }
        } else {
            Document tempImplementation = SerializerImpl.cloneDocument(this.manifest.getImplementation(), "META-INF/manifest.xml");
            this.tempManifest = new ManifestImpl(tempImplementation, new WriteOnlyStorage(this.getOutputTarget()));
            if (newNormalizer != null) {
                this.tempManifest.setStreamNormalizer(newNormalizer);
            } else {
                this.tempManifest.setStreamNormalizer(oldNormalizer);
            }
            new WorkbookImpl(DOMUtils.createDocument(), this.tempManifest);
        }
        MetaImpl meta = workbook.getMeta();
        String creatorName = this.getCreatorName();
        if (creatorName != null) {
            meta.setValue("Creator/Name", creatorName);
        }
        if ((creatorVersion = this.getCreatorVersion()) != null) {
            meta.setValue("Creator/Version", creatorVersion);
        }
        this.serializeXML(meta, "meta.xml");
        this.serializeXML(workbook, "content.xml");
        MarkerSheetImpl markerSheet = workbook.getMarkerSheet();
        if (this.usesWorkbookStorageAsOutputTarget || !markerSheet.isEmpty()) {
            this.serializeXML(markerSheet, "markers/markerSheet.xml");
        } else {
            this.tempManifest.deleteFileEntry("markers/markerSheet.xml");
            this.serializedEntryPaths.add("markers/markerSheet.xml");
        }
        StyleSheetImpl styleSheet = workbook.getStyleSheet();
        if (this.usesWorkbookStorageAsOutputTarget || !styleSheet.isEmpty()) {
            this.serializeXML(styleSheet, "styles.xml");
        } else {
            this.tempManifest.deleteFileEntry("styles.xml");
            this.serializedEntryPaths.add("styles.xml");
        }
        ICommentManager commentManager = workbook.getCommentManager();
        if (this.usesWorkbookStorageAsOutputTarget || !commentManager.isEmpty()) {
            this.serializeXML(commentManager, "comments.xml");
        } else {
            this.tempManifest.deleteFileEntry("comments.xml");
            this.serializedEntryPaths.add("comments.xml");
        }
        IWorkbookExtensionManager extensionManager = workbook.getAdapter(IWorkbookExtensionManager.class);
        List<IWorkbookExtension> exts = extensionManager.getExtensions();
        for (IWorkbookExtension ext : exts) {
            String providerName = ext.getProviderName();
            String path = "extensions/" + (String)providerName + ".xml";
            this.serializeXML(ext, path);
        }
        IRevisionRepository revisionRepository = workbook.getRevisionRepository();
        for (String resourceId : revisionRepository.getRegisteredResourceIds()) {
            IRevisionManager manager = revisionRepository.getRegisteredRevisionManager(resourceId);
            if (manager == null) continue;
            String path = "Revisions/" + resourceId + "/" + "revisions.xml";
            this.serializeXML(manager, path);
        }
        Iterator<IFileEntry> sourceEntryIter = !this.usesWorkbookStorageAsOutputTarget ? this.manifest.iterFileEntries() : (normalizerChanged ? this.manifest.getAllRegisteredEntries().iterator() : null);
        while (sourceEntryIter != null && sourceEntryIter.hasNext()) {
            IFileEntry targetEntry;
            String entryPath;
            IFileEntry sourceEntry = sourceEntryIter.next();
            if (sourceEntry.isDirectory() || !sourceEntry.canRead() || "META-INF/manifest.xml".equals(entryPath = sourceEntry.getPath()) || this.serializedEntryPaths.contains(entryPath) || (targetEntry = this.tempManifest.getFileEntry(entryPath)) == null) continue;
            if (this.usesWorkbookStorageAsOutputTarget) {
                String tempEntryPath = this.makeTempPath(entryPath);
                this.manifest.setStreamNormalizer(oldNormalizer);
                InputStream entryInput = sourceEntry.openInputStream();
                try {
                    OutputStream tempOutput = this.tempManifest.getStorage().getOutputTarget().openEntryStream(tempEntryPath);
                    try {
                        FileUtils.transfer(entryInput, tempOutput, false);
                    }
                    finally {
                        tempOutput.close();
                    }
                }
                finally {
                    entryInput.close();
                }
                this.tempManifest.setStreamNormalizer(newNormalizer);
                InputStream tempInput = this.tempManifest.getStorage().getInputSource().openEntryStream(tempEntryPath);
                try {
                    OutputStream entryOutput = this.openEntryOutputStream(entryPath);
                    try {
                        FileUtils.transfer(tempInput, entryOutput, false);
                        continue;
                    }
                    finally {
                        entryOutput.close();
                    }
                }
                finally {
                    tempInput.close();
                }
            }
            InputStream entryInput = sourceEntry.openInputStream();
            try {
                OutputStream entryOutput = this.openEntryOutputStream(entryPath);
                try {
                    FileUtils.transfer(entryInput, entryOutput, false);
                }
                finally {
                    entryOutput.close();
                }
            }
            finally {
                entryInput.close();
            }
        }
        if (this.usesWorkbookStorageAsOutputTarget && normalizerChanged) {
            this.manifest.setStreamNormalizer(newNormalizer);
        }
        this.serializeXML(this.tempManifest, "META-INF/manifest.xml");
        if (this.intermediateOutputStream != null) {
            this.intermediateOutputStream.finish();
            this.intermediateOutputStream.flush();
            this.intermediateOutputStream.close();
        }
    }

    private static Document cloneDocument(Document document, String xmlName) throws CoreException {
        try {
            Transformer transformer = SerializerImpl.createXMLSerializer();
            DOMResult result = new DOMResult();
            transformer.transform(new DOMSource(document), result);
            return (Document)result.getNode();
        }
        catch (TransformerException e) {
            throw new CoreException(18, xmlName, e);
        }
    }

    private static Transformer createXMLSerializer() throws CoreException {
        return DOMUtils.getDefaultTransformer();
    }

    private String makeTempPath(String path) {
        int sepIndex = path.lastIndexOf(47);
        if (sepIndex >= 0) {
            return String.valueOf(path.substring(0, sepIndex + 1)) + "._." + path.substring(sepIndex + 1);
        }
        return "._." + path;
    }

    private void serializeXML(IAdaptable domAdaptable, String entryPath) throws IOException, CoreException {
        Node node = domAdaptable.getAdapter(Node.class);
        if (node == null) {
            throw new CoreException(3, "Object has no DOM node");
        }
        Transformer transformer = SerializerImpl.createXMLSerializer();
        OutputStream out = this.openEntryOutputStream(entryPath);
        try {
            try {
                transformer.transform(new DOMSource(node), new StreamResult(out));
            }
            catch (TransformerException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new CoreException(18, entryPath, e);
            }
        }
        finally {
            out.close();
        }
        this.serializedEntryPaths.add(entryPath);
    }

    private OutputStream openEntryOutputStream(String entryPath) throws IOException, CoreException {
        IFileEntry entry = this.tempManifest.getFileEntry(entryPath);
        if (this.isEntryEncryptionIgnored(entryPath)) {
            entry.deleteEncryptionData();
            return this.tempManifest.getStorage().getOutputTarget().openEntryStream(entryPath);
        }
        if (entry == null) {
            entry = this.tempManifest.createFileEntry(entryPath);
            entry.increaseReference();
        }
        return entry.openOutputStream();
    }

    private static class WriteOnlyStorage
    implements IStorage {
        private IOutputTarget target;

        public WriteOnlyStorage(IOutputTarget target) {
            this.target = target;
        }

        public IInputSource getInputSource() {
            throw new UnsupportedOperationException();
        }

        public IOutputTarget getOutputTarget() {
            return this.target;
        }

        public String getName() {
            return this.toString();
        }

        public String getFullPath() {
            return this.getName();
        }

        public void clear() {
        }

        public void deleteEntry(String entryName) {
        }

        public void renameEntry(String entryName, String newName) {
        }
    }
}

