/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.internal.share.dialogs;

import java.util.Timer;
import java.util.TimerTask;
import net.xmind.core.AccountManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.internal.share.GeneralSharePlugin;
import org.xmind.internal.share.Info;
import org.xmind.internal.share.dialogs.Messages;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.mindmap.MindMapViewerExportSourceProvider;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class ShareToDialog
extends TrayDialog {
    private static final int DEFAULT_EXPORT_MARGIN = 5;
    private static final int MINIMUM_PREVIEW_WIDTH = 420;
    private static final int MAXIMUM_PREVIEW_WIDTH = 1680;
    private static final String LANGUAGE_CHANNEL = "org.xmind.share.dialog.defaultLanguageChannel";
    private ResourceManager resources;
    private Info info;
    private String shellTitle;
    private String title;
    private String description;
    private String okButtonText;
    private String defaultMapTitle;
    private IMindMapViewer sourceViewer;
    private Text titleText;
    private Text descriptionText;
    private Composite contentComposite;
    private DialogCallback callback;
    private Timer timer;
    private int count;
    private Label descriptionLabel;
    private Image previewImage;

    public ShareToDialog(Shell parentShell, Info info, String shellTitle, String title, String description, String okButtonText, String defaultMapTitle, IMindMapViewer sourceViewer) {
        super(parentShell);
        this.info = info;
        this.shellTitle = shellTitle;
        this.title = title;
        this.description = description;
        this.okButtonText = okButtonText;
        this.defaultMapTitle = defaultMapTitle;
        this.sourceViewer = sourceViewer;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.shellTitle);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)newShell);
        this.setBlockOnOpen(true);
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        buttonBar.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f3f3f3")));
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        parent.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f3f3f3")));
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = this.okButtonText;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        ShareToDialog.applyDialogFont((Control)composite);
        this.createDescriptionSection(composite);
        this.contentComposite = this.createContentSection(composite);
        return composite;
    }

    private void createDescriptionSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 16;
        gridLayout.marginHeight = 16;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 6;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        titleLabel.setBackground(composite.getBackground());
        titleLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#555555")));
        titleLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold((FontData[])FontUtils.relativeHeight((FontData[])titleLabel.getFont().getFontData(), (int)1), (boolean)true))));
        titleLabel.setText(this.title);
        this.descriptionLabel = new Label(composite, 64);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 501;
        this.descriptionLabel.setLayoutData((Object)gridData);
        this.descriptionLabel.setBackground(composite.getBackground());
        this.descriptionLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#555555")));
        this.descriptionLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.descriptionLabel.getFont().getFontData(), (int)1))));
        this.descriptionLabel.setText(this.description);
    }

    private Composite createContentSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createSeparator(composite);
        Composite composite2 = new Composite(composite, 0);
        GridData layoutData2 = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)layoutData2);
        composite2.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f3f3f3")));
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 19;
        layout2.marginHeight = 20;
        layout2.verticalSpacing = 0;
        layout2.horizontalSpacing = 21;
        composite2.setLayout((Layout)layout2);
        this.createPreviewSection(composite2);
        this.createRightSection(composite2);
        return composite;
    }

    private void createSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Composite separator = new Composite(composite, 0);
        GridData layoutData2 = new GridData(4, 0x1000000, true, false);
        separator.setLayoutData((Object)layoutData2);
        layoutData2.heightHint = 1;
        separator.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#b0b0b0")));
        separator.setLayout((Layout)new GridLayout());
    }

    private void createPreviewSection(final Composite parent) {
        Composite border = new Composite(parent, 0);
        GridData layoutData = new GridData(0x1000000, 128, false, false);
        layoutData.widthHint = 240;
        if (Util.isWindows()) {
            layoutData.heightHint = 148;
            layoutData.verticalIndent = 24;
        } else {
            layoutData.heightHint = 145;
            layoutData.verticalIndent = 25;
        }
        border.setLayoutData((Object)layoutData);
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#abadb3")));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        border.setLayout((Layout)layout);
        final Composite composite = new Composite(border, 0);
        GridData layoutData2 = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData2);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        composite.setLayout((Layout)new GridLayout());
        final Label textLabel = new Label(composite, 0);
        textLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        textLabel.setBackground(composite.getBackground());
        textLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#b0b0b0")));
        textLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])textLabel.getFont().getFontData(), (int)-1))));
        textLabel.setText(Messages.ShareToDialog_previewImage_label);
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ShareToDialog.this.previewImage = ShareToDialog.this.generatePreviewImage(parent.getDisplay());
                textLabel.dispose();
                composite.redraw();
            }
        });
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ShareToDialog.this.previewImage != null) {
                    ShareToDialog.this.drawImage(ShareToDialog.this.previewImage, e.gc, composite.getBounds());
                }
            }
        });
    }

    private Image generatePreviewImage(Display display) {
        if (this.sourceViewer == null) {
            return null;
        }
        MindMapImageExporter exporter = new MindMapImageExporter(display);
        MindMapViewerExportSourceProvider sourceProvider = new MindMapViewerExportSourceProvider((IGraphicalViewer)this.sourceViewer, 5);
        Rectangle sourceArea = sourceProvider.getSourceArea();
        int resizeWidth = Math.max(sourceArea.width % 21 == 0 ? sourceArea.width : sourceArea.width + 21 - sourceArea.width % 21, sourceArea.height % 13 == 0 ? sourceArea.height * 21 / 13 : (sourceArea.height + 13 - sourceArea.height % 13) * 21 / 13);
        if (resizeWidth < 420) {
            resizeWidth = 420;
        } else if (resizeWidth > 1680) {
            resizeWidth = 1680;
        }
        int resizeHeight = resizeWidth * 13 / 21;
        exporter.setSourceProvider(sourceProvider);
        exporter.setResize(1, resizeWidth, resizeHeight);
        exporter.setTargetWorkbook(this.sourceViewer.getSheet().getOwnedWorkbook());
        Image previewImage = exporter.createImage();
        exporter.export(previewImage);
        return previewImage;
    }

    private void drawImage(Image image, GC gc, org.eclipse.swt.graphics.Rectangle area) {
        org.eclipse.swt.graphics.Rectangle bounds = this.previewImage.getBounds();
        double ratio = Math.max((double)area.width / (double)bounds.width, (double)area.height / (double)bounds.height);
        double srcWidth = Math.min((double)bounds.width, (double)area.width / ratio);
        double srcHeight = Math.min((double)bounds.height, (double)area.height / ratio);
        double srcX = Math.max(0.0, ((double)bounds.width - srcWidth) / 2.0);
        double srcY = Math.max(0.0, ((double)bounds.height - srcHeight) / 2.0);
        double destWidth = srcWidth * ratio;
        double destHeight = srcHeight * ratio;
        double destX = (double)area.x + ((double)area.width - destWidth) / 2.0;
        double destY = (double)area.y + ((double)area.height - destHeight) / 2.0;
        gc.setAntialias(1);
        gc.drawImage(image, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)destX, (int)destY, (int)destWidth, (int)destHeight);
    }

    private void createRightSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 11;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createTitleInputSection(composite);
        this.createDescriptionInputSection(composite);
        this.createLanguageSection(composite);
    }

    private void createTitleInputSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        titleLabel.setBackground(composite.getBackground());
        titleLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#555555")));
        titleLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold((FontData[])FontUtils.relativeHeight((FontData[])titleLabel.getFont().getFontData(), (int)1), (boolean)true))));
        titleLabel.setText(Messages.ShareToDialog_dialog_title);
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        composite2.setBackground(composite.getBackground());
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.titleText = new Text(composite2, 16450);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 294;
        gridData.heightHint = 27;
        this.titleText.setLayoutData((Object)gridData);
        this.titleText.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.titleText.getFont().getFontData(), (int)1))));
        String mapTitle = this.defaultMapTitle == null ? "" : this.defaultMapTitle;
        this.titleText.setText(mapTitle);
    }

    private void createDescriptionInputSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        descriptionLabel.setBackground(composite.getBackground());
        descriptionLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#555555")));
        descriptionLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold((FontData[])FontUtils.relativeHeight((FontData[])descriptionLabel.getFont().getFontData(), (int)1), (boolean)true))));
        descriptionLabel.setText(Messages.ShareToDialog_description_text);
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        composite2.setBackground(composite.getBackground());
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.descriptionText = new Text(composite2, 16450);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 294;
        gridData.heightHint = 78;
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.descriptionText.getFont().getFontData(), (int)1))));
    }

    private void createLanguageSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 3;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        label.setBackground(composite.getBackground());
        label.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#555555")));
        label.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])label.getFont().getFontData(), (int)1))));
        label.setText(Messages.ShareToDialog_languageChannel_text);
        final Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        combo.setBackground(composite.getBackground());
        combo.setItems(new String[]{"English", "Chinese - \u4e2d\u6587", "French - fran\u00e7ais", "German - Deutsch", "Japanese - \u65e5\u672c\u8a9e", "Spanish - espa\u00f1ol", "Worldwide"});
        final IPreferenceStore prefStore = GeneralSharePlugin.getDefault().getPreferenceStore();
        String lang = prefStore.getString(LANGUAGE_CHANNEL);
        if (lang == null || "".equals(lang)) {
            lang = Info.getDefaultLanguageCode();
        }
        this.info.setProperty("Share/LanguageChannel", lang);
        int index = Info.LANGUAGE_CODES.indexOf(lang);
        if (index < 0) {
            index = Info.LANGUAGE_CODES.size() - 1;
        }
        combo.select(index);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = Math.min(combo.getSelectionIndex(), Info.LANGUAGE_CODES.size() - 1);
                String lang = Info.LANGUAGE_CODES.get(index);
                prefStore.setValue(ShareToDialog.LANGUAGE_CHANNEL, lang);
                ShareToDialog.this.info.setProperty("Share/LanguageChannel", lang);
            }
        });
    }

    public int open(DialogCallback callback) {
        this.callback = callback;
        return this.open();
    }

    protected void okPressed() {
        String mapTitle = this.titleText.getText();
        if (mapTitle == null || "".equals(mapTitle)) {
            mapTitle = this.defaultMapTitle;
        }
        this.info.setProperty("Title", this.titleText.getText());
        this.info.setProperty("Description", this.descriptionText.getText());
        if (this.callback != null) {
            this.callback.okPressed();
        }
    }

    public void showUploading() {
        if (this.contentComposite == null || this.contentComposite.isDisposed()) {
            return;
        }
        Control[] controlArray = this.contentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            Object var1_4 = null;
            ++n2;
        }
        this.descriptionLabel.setText(this.info.getString("Title"));
        this.createUploadingSection(this.contentComposite);
        this.getButton(0).setEnabled(false);
        this.getButtonBar().setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        this.getButton(0).getParent().setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        this.getShell().pack();
        this.getShell().layout(true, true);
    }

    private void createUploadingSection(Composite parent) {
        Composite shadowComposite = new Composite(parent, 0);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 603;
        shadowComposite.setLayoutData((Object)layoutData);
        shadowComposite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 46;
        layout.marginTop = 1;
        layout.marginWidth = 0;
        shadowComposite.setLayout((Layout)layout);
        Composite composite = new Composite(shadowComposite, 0);
        GridData layoutData2 = new GridData(0x1000000, 0x1000000, true, true);
        composite.setLayoutData((Object)layoutData2);
        composite.setBackground(shadowComposite.getBackground());
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginHeight = 37;
        layout2.marginWidth = 0;
        layout2.verticalSpacing = 29;
        layout2.horizontalSpacing = 0;
        composite.setLayout((Layout)layout2);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setBackground(composite.getBackground());
        imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.createLoadingAnimation(imageLabel, 9);
        Label textLabel = new Label(composite, 0);
        textLabel.setBackground(composite.getBackground());
        textLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        textLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#b8b8b8")));
        textLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])textLabel.getFont().getFontData(), (int)4))));
        textLabel.setText(Messages.ShareToDialog_uploading_button_text);
    }

    private void createLoadingAnimation(final Label imageLabel, final int totalImage) {
        imageLabel.setImage((Image)this.resources.get((DeviceResourceDescriptor)GeneralSharePlugin.get("loading/0.png")));
        final Display display = imageLabel.getDisplay();
        this.timer = new Timer();
        this.count = 1;
        TimerTask task = new TimerTask(){

            public void run() {
                if (display == null) {
                    ShareToDialog.this.timer.cancel();
                    ShareToDialog.this.timer = null;
                    return;
                }
                display.syncExec(new Runnable(){

                    public void run() {
                        if (imageLabel == null || imageLabel.isDisposed()) {
                            if (ShareToDialog.this.timer != null) {
                                ShareToDialog.this.timer.cancel();
                                ShareToDialog.this.timer = null;
                            }
                        } else {
                            String imagePath = String.valueOf(ShareToDialog.this.count % totalImage) + ".png";
                            imageLabel.setImage((Image)ShareToDialog.this.resources.get((DeviceResourceDescriptor)GeneralSharePlugin.get("loading/" + imagePath)));
                            ShareToDialog shareToDialog = ShareToDialog.this;
                            shareToDialog.count = shareToDialog.count + 1;
                        }
                    }
                });
            }
        };
        this.timer.schedule(task, 400L, 150L);
    }

    public void showLink(String hyperlink) {
        this.showLink(hyperlink, true);
    }

    public void showEmbedCode(String hyperlink) {
        this.showLink(hyperlink, false);
    }

    private void showLink(String hyperlink, boolean isLink) {
        if (this.contentComposite == null || this.contentComposite.isDisposed()) {
            return;
        }
        Control[] controlArray = this.contentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            Object var3_6 = null;
            ++n2;
        }
        this.createLinkSection(this.contentComposite, hyperlink, isLink);
        --((GridLayout)this.getButton((int)0).getParent().getLayout()).numColumns;
        this.getButton(0).dispose();
        this.getButton(1).setText(Messages.ShareToDialog_close_button_text);
        ((Composite)this.getButtonBar()).layout();
        this.getShell().pack();
        this.getShell().layout(true, true);
    }

    private void createLinkSection(Composite parent, String hyperlink, boolean isLink) {
        Composite shadowComposite = new Composite(parent, 0);
        GridData layoutData = new GridData(1808);
        shadowComposite.setLayoutData((Object)layoutData);
        shadowComposite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 30;
        layout.marginWidth = 16;
        shadowComposite.setLayout((Layout)layout);
        Composite composite = new Composite(shadowComposite, 0);
        GridData layoutData2 = new GridData(4, 0x1000000, true, true);
        composite.setLayoutData((Object)layoutData2);
        composite.setBackground(shadowComposite.getBackground());
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.verticalSpacing = 0;
        layout2.horizontalSpacing = 0;
        composite.setLayout((Layout)layout2);
        Label linkLabel = new Label(composite, 0);
        linkLabel.setBackground(composite.getBackground());
        linkLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        linkLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#555555")));
        linkLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold((FontData[])FontUtils.relativeHeight((FontData[])linkLabel.getFont().getFontData(), (int)1), (boolean)true))));
        linkLabel.setText(isLink ? Messages.ShareToDialog_link_text : Messages.ShareToDialog_embedCode_text);
        Text link = this.createLink(composite, isLink);
        link.setText(isLink ? hyperlink : this.getEmbedCode(hyperlink));
        link.selectAll();
        link.forceFocus();
    }

    private Text createLink(final Composite parent, boolean isLink) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(1808);
        layoutData.verticalIndent = 20;
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        int textStyle = isLink ? 4 : 66;
        final Text link = new Text(composite, textStyle | 8 | 0x800);
        link.setBackground(composite.getBackground());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 489;
        gridData.heightHint = 54;
        link.setLayoutData((Object)gridData);
        link.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#555555")));
        link.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])link.getFont().getFontData(), (int)(isLink ? 2 : 1)))));
        Hyperlink copyButton = new Hyperlink(composite, 0);
        copyButton.setBackground(composite.getBackground());
        copyButton.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#4a90e2")));
        copyButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        copyButton.setUnderlined(true);
        copyButton.setText(Messages.ShareToDialog_copyToClipboard_title);
        final Label copyTipLabel = new Label(composite, 0);
        copyTipLabel.setBackground(composite.getBackground());
        copyTipLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#777777")));
        GridData gridData2 = new GridData(131072, 0x1000000, true, false);
        copyTipLabel.setLayoutData((Object)gridData2);
        copyTipLabel.setText(isLink ? Messages.ShareToDialog_copyLink_text : Messages.ShareToDialog_copyCode_text);
        copyTipLabel.setVisible(false);
        copyButton.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                Clipboard clipboard = new Clipboard(parent.getDisplay());
                try {
                    clipboard.setContents(new Object[]{link.getText()}, new Transfer[]{TextTransfer.getInstance()});
                }
                finally {
                    clipboard.dispose();
                }
                copyTipLabel.setVisible(true);
            }
        });
        return link;
    }

    private String getEmbedCode(String hyperlink) {
        String mapHash = hyperlink.substring(hyperlink.lastIndexOf("/") + 1);
        boolean isCnUser = AccountManager.getPrimaryAccount().isCnUser();
        String link = LinkUtils.getLinkByUser((boolean)isCnUser, (boolean)true, (boolean)false, (String)("/embed/" + mapHash));
        String embedCode = "<iframe src=\"" + link + "\" width=\"900px\" height=\"540px\"></iframe>";
        return embedCode;
    }

    public static interface DialogCallback {
        public void okPressed();
    }
}

