/*
 * Decompiled with CFR 0.152.
 */
package httpserv;

import com.sun.net.httpserver.HttpServer;
import httpserv.MyHandler;
import httpserv.Option;
import java.net.InetSocketAddress;

public class Main {
    public static void main(String[] args) {
        try {
            Option[] opts = new Option[]{new Option("--help", "-h", false), new Option("--accept", "-a", true)};
            if (!Main.parseOptions(args, opts)) {
                return;
            }
            HttpServer server = HttpServer.create(new InetSocketAddress((Integer)opts[1].value), 0);
            server.createContext("/", new MyHandler());
            server.setExecutor(null);
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean parseOptions(String[] args, Option[] inout_options) {
        if (args.length == 0) {
            Main.printUsage();
            return false;
        }
        boolean bWrongArgs = true;
        Option currentOpt = null;
        block2: for (String s : args) {
            if (currentOpt != null && currentOpt.bHasValue) {
                try {
                    if (currentOpt.sLong.equals("--accept")) {
                        currentOpt.value = Integer.decode(s);
                    }
                }
                catch (Exception e) {
                    Main.printUsage();
                    return false;
                }
                currentOpt = null;
                continue;
            }
            currentOpt = null;
            for (Option o : inout_options) {
                if (!s.equals(o.sLong) && !s.equals(o.sShort)) continue;
                bWrongArgs = false;
                if (o.sLong.equals("--help")) {
                    Main.printUsage();
                    return false;
                }
                currentOpt = o;
                if (o.bHasValue) continue block2;
                o.bSet = true;
                continue block2;
            }
        }
        if (bWrongArgs) {
            Main.printUsage();
            return false;
        }
        return true;
    }

    static void printUsage() {
        String usage = new String("Usage: \njava -jar httpserv [options] \n\nOptions are: \n-h --help \t this help \n-a --accept port \t the port number to which this server listens \n");
        System.out.println(usage);
    }
}

