
# -*- Mode: makefile; tab-width: 4; indent-tabs-mode: t -*-
#
# Version: MPL 1.1 / GPLv3+ / LGPLv3+
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License or as specified alternatively below. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Initial Developer of the Original Code is
# Norbert Thiebaud <nthiebaud@gmail.com>
# Portions created by the Initial Developer are Copyright (C) 2012 the
# Initial Developer. All Rights Reserved.
#
# For minor contributions see the git repository.
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 3 or later (the "GPLv3+"), or
# the GNU Lesser General Public License Version 3 or later (the "LGPLv3+"),
# in which case the provisions of the GPLv3+ or the LGPLv3+ are applicable
# instead of those above.
#

$(eval $(call gb_Library_Library,AppleRemote))

$(eval $(call gb_Library_use_package,AppleRemote,\
    apple_remote_inc \
))

$(eval $(call gb_Library_use_externals,AppleRemote,\
    cocoa \
    carbon \
    iokit \
))

$(eval $(call gb_Library_add_libs,AppleRemote,\
    -framework Cocoa \
    -framework Carbon \
    -framework IOKit \
))

$(eval $(call gb_Library_add_objcobjects,AppleRemote,\
    apple_remote/source/KeyspanFrontRowControl \
    apple_remote/source/AppleRemote \
    apple_remote/source/RemoteControl \
    apple_remote/source/RemoteControlContainer \
    apple_remote/source/GlobalKeyboardDevice \
    apple_remote/source/HIDRemoteControlDevice \
    apple_remote/source/MultiClickRemoteBehavior \
    apple_remote/source/RemoteMainController \
))
