# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
# Version: MPL 1.1 / GPLv3+ / LGPLv3+
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License or as specified alternatively below. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# Major Contributor(s):
# Copyright (C) 2012 Red Hat, Inc., Caolán McNamara <caolanm@redhat.com>
#  (initial developer)
#
# All Rights Reserved.
#
# For minor contributions see the git repository.
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 3 or later (the "GPLv3+"), or
# the GNU Lesser General Public License Version 3 or later (the "LGPLv3+"),
# in which case the provisions of the GPLv3+ or the LGPLv3+ are applicable
# instead of those above.

$(eval $(call gb_Library_Library,test))

$(eval $(call gb_Library_use_package,test,test_inc))

$(eval $(call gb_Library_add_defs,test,\
    -DOOO_DLLIMPLEMENTATION_TEST \
))

$(eval $(call gb_Library_use_api,test,\
    offapi \
    udkapi \
))

$(eval $(call gb_Library_use_externals,test,\
	libxml2 \
))

$(eval $(call gb_Library_use_libraries,test,\
    comphelper \
    cppu \
    cppuhelper \
	i18nisolang1 \
    sal \
	tl \
	utl \
	ucbhelper \
	unotest \
	vcl \
    $(gb_STDLIBS) \
))

ifeq ($(GUIBASE),unx)
$(call gb_Library_get_target,test) : \
    $(call gb_Library_get_target,desktop_detector) \
    $(call gb_Library_get_target,vclplug_svp) \

endif

$(eval $(call gb_Library_use_external,test,cppunit))

$(eval $(call gb_Library_add_exception_objects,test,\
    test/source/bootstrapfixture \
    test/source/diff/diff \
))

# vim: set noet sw=4 ts=4:
