# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#
# This file incorporates work covered by the following license notice:
#
#   Licensed to the Apache Software Foundation (ASF) under one or more
#   contributor license agreements. See the NOTICE file distributed
#   with this work for additional information regarding copyright
#   ownership. The ASF licenses this file to you under the Apache
#   License, Version 2.0 (the "License"); you may not use this file
#   except in compliance with the License. You may obtain a copy of
#   the License at http://www.apache.org/licenses/LICENSE-2.0 .
#

$(eval $(call gb_Library_Library,sw))

$(eval $(call gb_Library_add_sdi_headers,sw,sw/sdi/swslots))

$(eval $(call gb_Library_set_componentfile,sw,sw/util/sw))

$(eval $(call gb_Library_set_precompiled_header,sw,$(SRCDIR)/sw/inc/pch/precompiled_sw))

$(eval $(call gb_Library_set_include,sw,\
    -I$(SRCDIR)/sw/source/core/inc \
    -I$(SRCDIR)/sw/source/filter/inc \
    -I$(SRCDIR)/sw/source/core/uibase/inc \
    -I$(SRCDIR)/sw/inc \
    -I$(WORKDIR)/SdiTarget/sw/sdi \
    $$(INCLUDE) \
))

$(eval $(call gb_Library_use_custom_headers,sw,\
	officecfg/registry \
))

$(eval $(call gb_Library_use_sdk_api,sw))

$(eval $(call gb_Library_add_defs,sw,\
    -DSW_DLLIMPLEMENTATION \
	-DDBTOOLS_DLL_NAME=\"$(call gb_Library_get_runtime_filename,$(call gb_Library__get_name,dbtools))\" \
))

$(eval $(call gb_Library_use_libraries,sw,\
    $(call gb_Helper_optional,AVMEDIA,avmedia) \
    basegfx \
    comphelper \
    cppu \
    cppuhelper \
    drawinglayer \
    editeng \
    i18nlangtag \
    i18nutil \
    lng \
    sal \
    salhelper \
	sax \
    sb \
    sfx \
    sot \
    svl \
    svt \
    svx \
    svxcore \
    tk \
    tl \
    ucbhelper \
    utl \
    $(if $(filter TRUE,$(DISABLE_SCRIPTING)),, \
        vbahelper) \
    vcl \
    xmlreader \
    xo \
	$(gb_UWINAPI) \
))

$(eval $(call gb_Library_use_externals,sw,\
	boost_headers \
	icuuc \
	icu_headers \
	libxml2 \
))

$(eval $(call gb_Library_add_exception_objects,sw,\
    sw/source/core/SwNumberTree/SwNodeNum \
    sw/source/core/SwNumberTree/SwNumberTree \
    sw/source/core/access/acccell \
    sw/source/core/access/acccontext \
    sw/source/core/access/accdoc \
    sw/source/core/access/accembedded \
    sw/source/core/access/accfootnote \
    sw/source/core/access/accframe \
    sw/source/core/access/accframebase\
    sw/source/core/access/accfrmobj \
    sw/source/core/access/accfrmobjmap \
    sw/source/core/access/accfrmobjslist \
    sw/source/core/access/accgraphic \
    sw/source/core/access/accheaderfooter \
    sw/source/core/access/acchyperlink \
    sw/source/core/access/acchypertextdata \
    sw/source/core/access/accmap \
    sw/source/core/access/accnotextframe \
    sw/source/core/access/accnotexthyperlink \
    sw/source/core/access/accpage \
    sw/source/core/access/accpara \
    sw/source/core/access/accportions \
    sw/source/core/access/accpreview \
    sw/source/core/access/accselectionhelper \
    sw/source/core/access/acctable \
    sw/source/core/access/acctextframe \
    sw/source/core/access/parachangetrackinginfo \
    sw/source/core/access/textmarkuphelper \
    sw/source/core/attr/calbck \
    sw/source/core/attr/cellatr \
    sw/source/core/attr/fmtfollowtextflow \
    sw/source/core/attr/fmtwrapinfluenceonobjpos \
    sw/source/core/attr/format \
    sw/source/core/attr/hints \
    sw/source/core/attr/swatrset \
    sw/source/core/bastyp/SwSmartTagMgr \
    sw/source/core/bastyp/bparr \
    sw/source/core/bastyp/breakit \
    sw/source/core/bastyp/calc \
    sw/source/core/bastyp/checkit \
    sw/source/core/bastyp/index \
    sw/source/core/bastyp/init \
    sw/source/core/bastyp/ring \
    sw/source/core/bastyp/swcache \
    sw/source/core/bastyp/swrect \
    sw/source/core/bastyp/swregion \
    sw/source/core/bastyp/swtypes \
    sw/source/core/bastyp/tabcol \
    sw/source/core/crsr/annotationmark \
    sw/source/core/crsr/BlockCursor \
    sw/source/core/crsr/bookmrk \
    sw/source/core/crsr/callnk \
    sw/source/core/crsr/crbm \
    sw/source/core/crsr/crossrefbookmark \
    sw/source/core/crsr/crsrsh \
    sw/source/core/crsr/crstrvl \
    sw/source/core/crsr/crstrvl1 \
    sw/source/core/crsr/findattr \
    sw/source/core/crsr/findcoll \
    sw/source/core/crsr/findfmt \
    sw/source/core/crsr/findtxt \
    sw/source/core/crsr/pam \
    sw/source/core/crsr/paminit \
    sw/source/core/crsr/swcrsr \
    sw/source/core/crsr/trvlcol \
    sw/source/core/crsr/trvlfnfl \
    sw/source/core/crsr/trvlreg \
    sw/source/core/crsr/trvltbl \
    sw/source/core/crsr/unocrsr \
    sw/source/core/crsr/viscrs \
    sw/source/core/crsr/overlayrangesoutline \
    sw/source/core/doc/SwStyleNameMapper \
    sw/source/core/doc/acmplwrd \
    sw/source/core/doc/dbgoutsw \
    sw/source/core/doc/doc \
    sw/source/core/doc/docbasic \
    sw/source/core/doc/docbm \
    sw/source/core/doc/docchart \
    sw/source/core/doc/doccomp \
    sw/source/core/doc/doccorr \
    sw/source/core/doc/docdde \
    sw/source/core/doc/docdesc \
    sw/source/core/doc/docdraw \
    sw/source/core/doc/docedt \
    sw/source/core/doc/docfld \
    sw/source/core/doc/docfly \
    sw/source/core/doc/docfmt \
    sw/source/core/doc/docftn \
    sw/source/core/doc/docglbl \
    sw/source/core/doc/docglos \
    sw/source/core/doc/doclay \
    sw/source/core/doc/docnew \
    sw/source/core/doc/docnum \
    sw/source/core/doc/docredln \
    sw/source/core/doc/docruby \
    sw/source/core/doc/docsort \
    sw/source/core/doc/docstat \
    sw/source/core/doc/doctxm \
    sw/source/core/doc/DocumentDeviceManager \
    sw/source/core/doc/docxforms \
    sw/source/core/doc/DocumentSettingManager \
    sw/source/core/doc/extinput \
    sw/source/core/doc/fmtcol \
    sw/source/core/doc/ftnidx \
    sw/source/core/doc/gctable \
    sw/source/core/doc/htmltbl \
    sw/source/core/doc/lineinfo \
    sw/source/core/doc/list \
    sw/source/core/doc/notxtfrm \
    sw/source/core/doc/number \
    sw/source/core/doc/poolfmt \
    sw/source/core/doc/sortopt \
    sw/source/core/doc/swserv \
    sw/source/core/doc/swstylemanager \
    sw/source/core/doc/tblafmt \
    sw/source/core/doc/tblcpy \
    sw/source/core/doc/tblrwcl \
    sw/source/core/doc/visiturl \
    sw/source/core/docnode/cancellablejob \
    sw/source/core/docnode/finalthreadmanager \
    sw/source/core/docnode/ndcopy \
    sw/source/core/docnode/ndindex \
    sw/source/core/docnode/ndnotxt \
    sw/source/core/docnode/ndnum \
    sw/source/core/docnode/ndsect \
    sw/source/core/docnode/ndtbl \
    sw/source/core/docnode/ndtbl1 \
    sw/source/core/docnode/node \
    sw/source/core/docnode/nodedump \
    sw/source/core/docnode/node2lay \
    sw/source/core/docnode/nodes \
    sw/source/core/docnode/observablethread \
    sw/source/core/docnode/pausethreadstarting \
    sw/source/core/docnode/retrievedinputstreamdata \
    sw/source/core/docnode/retrieveinputstream \
    sw/source/core/docnode/retrieveinputstreamconsumer \
    sw/source/core/docnode/section \
    sw/source/core/docnode/swbaslnk \
    sw/source/core/docnode/swthreadjoiner \
    sw/source/core/docnode/swthreadmanager \
    sw/source/core/docnode/threadlistener \
    sw/source/core/docnode/threadmanager \
    sw/source/core/draw/dcontact \
    sw/source/core/draw/dflyobj \
    sw/source/core/draw/dobjfac \
    sw/source/core/draw/dpage \
    sw/source/core/draw/drawdoc \
    sw/source/core/draw/dview \
    sw/source/core/edit/acorrect \
    sw/source/core/edit/autofmt \
    sw/source/core/edit/edatmisc \
    sw/source/core/edit/edattr \
    sw/source/core/edit/eddel \
    sw/source/core/edit/edfcol \
    sw/source/core/edit/edfld \
    sw/source/core/edit/edfldexp \
    sw/source/core/edit/edfmt \
    sw/source/core/edit/edglbldc \
    sw/source/core/edit/edglss \
    sw/source/core/edit/editsh \
    sw/source/core/edit/edlingu \
    sw/source/core/edit/ednumber \
    sw/source/core/edit/edredln \
    sw/source/core/edit/edsect \
    sw/source/core/edit/edtab \
    sw/source/core/edit/edtox \
    sw/source/core/edit/edundo \
    sw/source/core/edit/edws \
    sw/source/core/fields/authfld \
    sw/source/core/fields/cellfml \
    sw/source/core/fields/chpfld \
    sw/source/core/fields/dbfld \
    sw/source/core/fields/ddefld \
    sw/source/core/fields/ddetbl \
    sw/source/core/fields/docufld \
    sw/source/core/fields/expfld \
    sw/source/core/fields/fldbas \
    sw/source/core/fields/flddat \
    sw/source/core/fields/flddropdown \
    sw/source/core/fields/fldlst \
    sw/source/core/fields/macrofld \
    sw/source/core/fields/postithelper \
    sw/source/core/fields/reffld \
    sw/source/core/fields/scrptfld \
    sw/source/core/fields/tblcalc \
    sw/source/core/fields/textapi \
    sw/source/core/fields/usrfld \
    sw/source/core/frmedt/fecopy \
    sw/source/core/frmedt/fedesc \
    sw/source/core/frmedt/fefly1 \
    sw/source/core/frmedt/feflyole \
    sw/source/core/frmedt/feshview \
    sw/source/core/frmedt/fetab \
    sw/source/core/frmedt/fews \
    sw/source/core/frmedt/tblsel \
    sw/source/core/graphic/grfatr \
    sw/source/core/graphic/ndgrf \
    sw/source/core/layout/anchoreddrawobject \
    sw/source/core/layout/anchoredobject \
    sw/source/core/layout/atrfrm \
    sw/source/core/layout/calcmove \
    sw/source/core/layout/colfrm \
    sw/source/core/layout/dbg_lay \
    sw/source/core/layout/dumpfilter \
    sw/source/core/layout/findfrm \
    sw/source/core/layout/flowfrm \
    sw/source/core/layout/fly \
    sw/source/core/layout/flycnt \
    sw/source/core/layout/flyincnt \
    sw/source/core/layout/flylay \
    sw/source/core/layout/flypos \
    sw/source/core/layout/frmtool \
    sw/source/core/layout/ftnfrm \
    sw/source/core/layout/hffrm \
    sw/source/core/layout/layact \
    sw/source/core/layout/laycache \
    sw/source/core/layout/layouter \
    sw/source/core/layout/movedfwdfrmsbyobjpos \
    sw/source/core/layout/newfrm \
    sw/source/core/layout/objectformatter \
    sw/source/core/layout/objectformatterlayfrm \
    sw/source/core/layout/objectformattertxtfrm \
    sw/source/core/layout/objstmpconsiderwrapinfl \
    sw/source/core/layout/pagechg \
    sw/source/core/layout/pagedesc \
    sw/source/core/layout/paintfrm \
    sw/source/core/layout/sectfrm \
    sw/source/core/layout/softpagebreak \
    sw/source/core/layout/sortedobjs \
    sw/source/core/layout/ssfrm \
    sw/source/core/layout/swselectionlist \
    sw/source/core/layout/tabfrm \
    sw/source/core/layout/trvlfrm \
    sw/source/core/layout/unusedf \
    sw/source/core/layout/virtoutp \
    sw/source/core/layout/wsfrm \
    sw/source/core/objectpositioning/anchoredobjectposition \
    sw/source/core/objectpositioning/ascharanchoredobjectposition \
    sw/source/core/objectpositioning/environmentofanchoredobject \
    sw/source/core/objectpositioning/tocntntanchoredobjectposition \
    sw/source/core/objectpositioning/tolayoutanchoredobjectposition \
    sw/source/core/ole/ndole \
    sw/source/core/para/paratr \
    sw/source/core/sw3io/sw3convert \
    sw/source/core/sw3io/swacorr \
    sw/source/core/swg/SwXMLBlockExport \
    sw/source/core/swg/SwXMLBlockImport \
    sw/source/core/swg/SwXMLBlockListContext \
    sw/source/core/swg/SwXMLSectionList \
    sw/source/core/swg/SwXMLTextBlocks \
    sw/source/core/swg/SwXMLTextBlocks1 \
    sw/source/core/swg/swblocks \
    sw/source/core/table/swnewtable \
    sw/source/core/table/swtable \
    sw/source/core/text/EnhancedPDFExportHelper \
    sw/source/core/text/SwGrammarMarkUp \
    sw/source/core/text/atrstck \
    sw/source/core/text/blink \
    sw/source/core/text/frmcrsr \
    sw/source/core/text/frmform \
    sw/source/core/text/frminf \
    sw/source/core/text/frmpaint \
    sw/source/core/text/guess \
    sw/source/core/text/inftxt \
    sw/source/core/text/itradj \
    sw/source/core/text/itratr \
    sw/source/core/text/itrcrsr \
    sw/source/core/text/itrform2 \
    sw/source/core/text/itrpaint \
    sw/source/core/text/itrtxt \
    sw/source/core/text/noteurl \
    sw/source/core/text/porexp \
    sw/source/core/text/porfld \
    sw/source/core/text/porfly \
    sw/source/core/text/porglue \
    sw/source/core/text/porlay \
    sw/source/core/text/porlin \
    sw/source/core/text/pormulti \
    sw/source/core/text/porref \
    sw/source/core/text/porrst \
    sw/source/core/text/portox \
    sw/source/core/text/portxt \
    sw/source/core/text/redlnitr \
    sw/source/core/text/txtcache \
    sw/source/core/text/txtdrop \
    sw/source/core/text/txtfld \
    sw/source/core/text/txtfly \
    sw/source/core/text/txtfrm \
    sw/source/core/text/txtftn \
    sw/source/core/text/txthyph \
    sw/source/core/text/txtinit \
    sw/source/core/text/txtio \
    sw/source/core/text/txtpaint \
    sw/source/core/text/txttab \
    sw/source/core/text/widorp \
    sw/source/core/text/wrong \
    sw/source/core/text/xmldump \
    sw/source/core/tox/tox \
    sw/source/core/tox/toxhlp \
    sw/source/core/tox/txmsrt \
    sw/source/core/txtnode/SwGrammarContact \
    sw/source/core/txtnode/atrfld \
    sw/source/core/txtnode/atrflyin \
    sw/source/core/txtnode/atrftn \
    sw/source/core/txtnode/atrref \
    sw/source/core/txtnode/atrtox \
    sw/source/core/txtnode/chrfmt \
    sw/source/core/txtnode/fmtatr2 \
    sw/source/core/txtnode/fntcache \
    sw/source/core/txtnode/fntcap \
    sw/source/core/txtnode/modeltoviewhelper \
    sw/source/core/txtnode/ndhints \
    sw/source/core/txtnode/ndtxt \
    sw/source/core/txtnode/swfntcch \
    sw/source/core/txtnode/swfont \
    sw/source/core/txtnode/thints \
    sw/source/core/txtnode/txatbase \
    sw/source/core/txtnode/txatritr \
    sw/source/core/txtnode/txtatr2 \
    sw/source/core/txtnode/txtedt \
    sw/source/core/undo/SwRewriter \
    sw/source/core/undo/SwUndoField \
    sw/source/core/undo/SwUndoFmt \
    sw/source/core/undo/SwUndoPageDesc \
    sw/source/core/undo/SwUndoTOXChange \
    sw/source/core/undo/docundo \
    sw/source/core/undo/rolbck \
    sw/source/core/undo/unattr \
    sw/source/core/undo/unbkmk \
    sw/source/core/undo/undel \
    sw/source/core/undo/undobj \
    sw/source/core/undo/undobj1 \
    sw/source/core/undo/undoflystrattr \
    sw/source/core/undo/undraw \
    sw/source/core/undo/unfmco \
    sw/source/core/undo/unins \
    sw/source/core/undo/unmove \
    sw/source/core/undo/unnum \
    sw/source/core/undo/unoutl \
    sw/source/core/undo/unovwr \
    sw/source/core/undo/unredln \
    sw/source/core/undo/unsect \
    sw/source/core/undo/unsort \
    sw/source/core/undo/unspnd \
    sw/source/core/undo/untbl \
    sw/source/core/undo/untblk \
    sw/source/core/unocore/SwXTextDefaults \
    sw/source/core/unocore/TextCursorHelper  \
    sw/source/core/unocore/XMLRangeHelper \
    sw/source/core/unocore/swunohelper \
    sw/source/core/unocore/unobkm \
    sw/source/core/unocore/unochart \
    sw/source/core/unocore/unocoll \
    sw/source/core/unocore/unocrsrhelper \
    sw/source/core/unocore/unodraw \
    sw/source/core/unocore/unoevent \
    sw/source/core/unocore/unofield \
    sw/source/core/unocore/unoflatpara \
    sw/source/core/unocore/unoframe \
    sw/source/core/unocore/unoftn \
    sw/source/core/unocore/unoidx \
    sw/source/core/unocore/unomap \
    sw/source/core/unocore/unoobj \
    sw/source/core/unocore/unoobj2 \
    sw/source/core/unocore/unoparagraph \
    sw/source/core/unocore/unoport \
    sw/source/core/unocore/unoportenum \
    sw/source/core/unocore/unoredline \
    sw/source/core/unocore/unoredlines \
    sw/source/core/unocore/unorefmk \
    sw/source/core/unocore/unosect \
    sw/source/core/unocore/unosett \
    sw/source/core/unocore/unosrch \
    sw/source/core/unocore/unostyle \
    sw/source/core/unocore/unotbl  \
    sw/source/core/unocore/unotext \
    sw/source/core/unocore/unotextmarkup \
    sw/source/core/view/pagepreviewlayout \
    sw/source/core/view/printdata \
    sw/source/core/view/vdraw \
    sw/source/core/view/viewimp \
    sw/source/core/view/viewpg \
    sw/source/core/view/viewsh \
    sw/source/core/view/vnew \
    sw/source/core/view/vprint \
    sw/source/filter/ascii/ascatr \
    sw/source/filter/ascii/parasc \
    sw/source/filter/ascii/wrtasc \
    sw/source/filter/basflt/docfact \
    sw/source/filter/basflt/fltini \
    sw/source/filter/basflt/iodetect \
    sw/source/filter/basflt/shellio \
    sw/source/filter/html/SwAppletImpl \
    sw/source/filter/html/css1atr \
    sw/source/filter/html/css1kywd \
    sw/source/filter/html/htmlatr \
    sw/source/filter/html/htmlbas \
    sw/source/filter/html/htmlcss1 \
    sw/source/filter/html/htmlctxt \
    sw/source/filter/html/htmldrawreader \
    sw/source/filter/html/htmldrawwriter \
    sw/source/filter/html/htmlfld \
    sw/source/filter/html/htmlfldw \
    sw/source/filter/html/htmlfly \
    sw/source/filter/html/htmlflywriter \
    sw/source/filter/html/htmlflyt \
    sw/source/filter/html/htmlform \
    sw/source/filter/html/htmlforw \
    sw/source/filter/html/htmlftn \
    sw/source/filter/html/htmlgrin \
    sw/source/filter/html/htmlnum \
    sw/source/filter/html/htmlnumreader \
    sw/source/filter/html/htmlnumwriter \
    sw/source/filter/html/htmlplug \
    sw/source/filter/html/htmlsect \
    sw/source/filter/html/htmltab \
    sw/source/filter/html/htmltabw \
    sw/source/filter/html/parcss1 \
    sw/source/filter/html/svxcss1 \
    sw/source/filter/html/swhtml \
    sw/source/filter/html/wrthtml \
    sw/source/filter/writer/writer \
    sw/source/filter/writer/wrt_fn \
    sw/source/filter/writer/wrtswtbl \
    sw/source/filter/ww1/fltshell \
    sw/source/filter/ww1/w1class \
    sw/source/filter/ww1/w1filter \
    sw/source/filter/ww1/w1par \
    sw/source/filter/ww1/w1sprm \
    sw/source/filter/xml/XMLRedlineImportHelper \
    sw/source/filter/xml/swxml \
    sw/source/filter/xml/wrtxml \
    sw/source/filter/xml/xmlbrsh \
    sw/source/filter/xml/xmlexp \
    sw/source/filter/xml/xmlexpit \
    sw/source/filter/xml/xmlfmt \
    sw/source/filter/xml/xmlfmte \
    sw/source/filter/xml/xmlfonte \
    sw/source/filter/xml/xmlimp \
    sw/source/filter/xml/xmlimpit \
    sw/source/filter/xml/xmlitem \
    sw/source/filter/xml/xmliteme \
    sw/source/filter/xml/xmlitemi \
    sw/source/filter/xml/xmlitemm \
    sw/source/filter/xml/xmlithlp \
    sw/source/filter/xml/xmlitmpr \
    sw/source/filter/xml/xmlmeta \
    sw/source/filter/xml/xmlscript \
    sw/source/filter/xml/xmltble \
    sw/source/filter/xml/xmltbli \
    sw/source/filter/xml/xmltext \
    sw/source/filter/xml/xmltexte \
    sw/source/filter/xml/xmltexti \
    sw/source/core/uibase/app/appenv \
    sw/source/core/uibase/app/apphdl \
    sw/source/core/uibase/app/applab \
    sw/source/core/uibase/app/appopt \
    sw/source/core/uibase/app/docsh \
    sw/source/core/uibase/app/docsh2 \
    sw/source/core/uibase/app/docshdrw \
    sw/source/core/uibase/app/docshini \
    sw/source/core/uibase/app/docst \
    sw/source/core/uibase/app/docstyle \
    sw/source/core/uibase/app/mainwn \
    sw/source/core/uibase/app/swdll \
    sw/source/core/uibase/app/swmodul1 \
    sw/source/core/uibase/app/swmodule \
    sw/source/core/uibase/app/swwait \
    sw/source/core/uibase/cctrl/actctrl \
    sw/source/core/uibase/cctrl/popbox \
    sw/source/core/uibase/cctrl/swlbox \
    sw/source/core/uibase/chrdlg/ccoll \
    sw/source/core/uibase/config/barcfg \
    sw/source/core/uibase/config/caption \
    sw/source/core/uibase/config/cfgitems \
    sw/source/core/uibase/config/dbconfig \
    sw/source/core/uibase/config/fontcfg \
    sw/source/core/uibase/config/modcfg \
    sw/source/core/uibase/config/prtopt \
    sw/source/core/uibase/config/uinums \
    sw/source/core/uibase/config/usrpref \
    sw/source/core/uibase/config/viewopt \
    sw/source/core/uibase/dialog/SwSpellDialogChildWindow \
    sw/source/core/uibase/dialog/regionsw \
    sw/source/core/uibase/dialog/swabstdlg \
    sw/source/core/uibase/dialog/swwrtshitem \
    sw/source/core/uibase/dochdl/gloshdl \
    sw/source/core/uibase/dochdl/swdtflvr \
    sw/source/core/uibase/docvw/AnchorOverlayObject \
    sw/source/core/uibase/docvw/AnnotationMenuButton \
    sw/source/core/uibase/docvw/AnnotationWin \
    sw/source/core/uibase/docvw/DashedLine \
	sw/source/core/uibase/docvw/FrameControlsManager \
    sw/source/core/uibase/docvw/PageBreakWin \
    sw/source/core/uibase/docvw/OverlayRanges \
    sw/source/core/uibase/docvw/PostItMgr \
    sw/source/core/uibase/docvw/ShadowOverlayObject \
    sw/source/core/uibase/docvw/SidebarTxtControl \
    sw/source/core/uibase/docvw/SidebarTxtControlAcc \
    sw/source/core/uibase/docvw/SidebarWin \
    sw/source/core/uibase/docvw/SidebarWinAcc \
    sw/source/core/uibase/docvw/HeaderFooterWin \
    sw/source/core/uibase/docvw/edtdd \
    sw/source/core/uibase/docvw/edtwin \
    sw/source/core/uibase/docvw/edtwin2 \
    sw/source/core/uibase/docvw/edtwin3 \
    sw/source/core/uibase/docvw/frmsidebarwincontainer \
    sw/source/core/uibase/docvw/romenu \
    sw/source/core/uibase/docvw/srcedtw \
    sw/source/core/uibase/envelp/envimg \
    sw/source/core/uibase/envelp/labelcfg \
    sw/source/core/uibase/envelp/labimg \
    sw/source/core/uibase/envelp/syncbtn \
    sw/source/core/uibase/fldui/fldmgr \
    sw/source/core/uibase/fldui/fldwrap \
    sw/source/core/uibase/fldui/xfldui \
    sw/source/core/uibase/frmdlg/colex \
    sw/source/core/uibase/frmdlg/colmgr \
    sw/source/core/uibase/frmdlg/frmmgr \
    sw/source/core/uibase/globdoc/globdoc \
    sw/source/core/uibase/index/idxmrk \
    sw/source/core/uibase/dialog/wordcountwrapper \
    sw/source/core/uibase/index/toxmgr \
    sw/source/core/uibase/lingu/hhcwrp \
    sw/source/core/uibase/lingu/hyp \
    sw/source/core/uibase/lingu/olmenu \
    sw/source/core/uibase/lingu/sdrhhcwrap \
    sw/source/core/uibase/misc/glosdoc \
    sw/source/core/uibase/misc/glshell \
    sw/source/core/uibase/misc/numberingtypelistbox \
    sw/source/core/uibase/misc/redlndlg \
    sw/source/core/uibase/misc/swruler \
    sw/source/core/uibase/ribbar/conarc \
    sw/source/core/uibase/ribbar/concustomshape \
    sw/source/core/uibase/ribbar/conform \
    sw/source/core/uibase/ribbar/conpoly \
    sw/source/core/uibase/ribbar/conrect \
    sw/source/core/uibase/ribbar/drawbase \
    sw/source/core/uibase/ribbar/dselect \
    sw/source/core/uibase/ribbar/inputwin \
    sw/source/core/uibase/ribbar/tblctrl \
    sw/source/core/uibase/ribbar/tbxanchr \
    sw/source/core/uibase/ribbar/workctrl \
    sw/source/core/uibase/shells/annotsh \
    sw/source/core/uibase/shells/basesh \
    sw/source/core/uibase/shells/beziersh \
    sw/source/core/uibase/shells/drawdlg \
    sw/source/core/uibase/shells/drawsh \
    sw/source/core/uibase/shells/drformsh \
    sw/source/core/uibase/shells/drwbassh \
    sw/source/core/uibase/shells/drwtxtex \
    sw/source/core/uibase/shells/drwtxtsh \
    sw/source/core/uibase/shells/frmsh \
    sw/source/core/uibase/shells/grfsh \
    sw/source/core/uibase/shells/grfshex \
    sw/source/core/uibase/shells/langhelper \
    sw/source/core/uibase/shells/listsh \
    sw/source/core/uibase/shells/mediash \
    sw/source/core/uibase/shells/navsh \
    sw/source/core/uibase/shells/olesh \
    sw/source/core/uibase/shells/slotadd \
    sw/source/core/uibase/shells/tabsh \
    sw/source/core/uibase/shells/textdrw \
    sw/source/core/uibase/shells/textfld \
    sw/source/core/uibase/shells/textglos \
    sw/source/core/uibase/shells/textidx \
    sw/source/core/uibase/shells/textsh \
    sw/source/core/uibase/shells/textsh1 \
    sw/source/core/uibase/shells/textsh2 \
    sw/source/core/uibase/shells/txtattr \
    sw/source/core/uibase/shells/txtcrsr \
    sw/source/core/uibase/shells/txtnum \
    sw/source/core/uibase/sidebar/PageOrientationControl \
    sw/source/core/uibase/sidebar/PageMarginControl \
    sw/source/core/uibase/sidebar/PageSizeControl \
    sw/source/core/uibase/sidebar/PageColumnControl \
    sw/source/core/uibase/sidebar/PagePropertyPanel \
    sw/source/core/uibase/sidebar/WrapPropertyPanel \
    sw/source/core/uibase/sidebar/SwPanelFactory \
    sw/source/core/uibase/smartmenu/stmenu \
    sw/source/core/uibase/table/chartins \
    sw/source/core/uibase/table/swtablerep \
    sw/source/core/uibase/table/tablemgr \
    sw/source/core/uibase/uiview/formatclipboard \
    sw/source/core/uibase/uiview/pview \
    sw/source/core/uibase/uiview/scroll \
    sw/source/core/uibase/uiview/srcview \
    sw/source/core/uibase/uiview/swcli \
    sw/source/core/uibase/uiview/uivwimp \
    sw/source/core/uibase/uiview/view \
    sw/source/core/uibase/uiview/view0 \
    sw/source/core/uibase/uiview/view1 \
    sw/source/core/uibase/uiview/view2 \
    sw/source/core/uibase/uiview/viewcoll \
    sw/source/core/uibase/uiview/viewdlg \
    sw/source/core/uibase/uiview/viewdlg2 \
    sw/source/core/uibase/uiview/viewdraw \
    sw/source/core/uibase/uiview/viewling \
    sw/source/core/uibase/uiview/viewmdi \
    sw/source/core/uibase/uiview/viewport \
    sw/source/core/uibase/uiview/viewprt \
    sw/source/core/uibase/uiview/viewsrch \
    sw/source/core/uibase/uiview/viewstat \
    sw/source/core/uibase/uiview/viewtab \
    sw/source/core/uibase/uno/SwXDocumentSettings \
    sw/source/core/uibase/uno/SwXFilterOptions \
    sw/source/core/uibase/uno/dlelstnr \
    sw/source/core/uibase/uno/unoatxt \
    sw/source/core/uibase/uno/unodefaults \
    sw/source/core/uibase/uno/unodispatch \
    sw/source/core/uibase/uno/unodoc \
    sw/source/core/uibase/uno/unofreg \
    sw/source/core/uibase/uno/unomod \
    sw/source/core/uibase/uno/unomodule \
    sw/source/core/uibase/uno/unotxdoc \
    sw/source/core/uibase/uno/unotxvw \
    sw/source/core/uibase/utlui/attrdesc \
    sw/source/core/uibase/utlui/bookctrl \
    sw/source/core/uibase/utlui/condedit \
    sw/source/core/uibase/utlui/content \
    sw/source/core/uibase/utlui/glbltree \
    sw/source/core/uibase/utlui/gloslst \
    sw/source/core/uibase/utlui/initui \
    sw/source/core/uibase/utlui/navicfg \
    sw/source/core/uibase/utlui/navipi \
    sw/source/core/uibase/utlui/numfmtlb \
    sw/source/core/uibase/utlui/prcntfld \
    sw/source/core/uibase/utlui/shdwcrsr \
    sw/source/core/uibase/utlui/tmplctrl \
    sw/source/core/uibase/utlui/uiitems \
    sw/source/core/uibase/utlui/uitool \
    sw/source/core/uibase/utlui/unotools \
    sw/source/core/uibase/utlui/viewlayoutctrl \
    sw/source/core/uibase/utlui/wordcountctrl \
    sw/source/core/uibase/utlui/zoomctrl \
    sw/source/core/uibase/web/wdocsh \
    sw/source/core/uibase/web/wformsh \
    sw/source/core/uibase/web/wfrmsh \
    sw/source/core/uibase/web/wgrfsh \
    sw/source/core/uibase/web/wlistsh \
    sw/source/core/uibase/web/wolesh \
    sw/source/core/uibase/web/wtabsh \
    sw/source/core/uibase/web/wtextsh \
    sw/source/core/uibase/web/wview \
    sw/source/core/uibase/wrtsh/delete \
    sw/source/core/uibase/wrtsh/move \
    sw/source/core/uibase/wrtsh/navmgr \
    sw/source/core/uibase/wrtsh/select \
    sw/source/core/uibase/wrtsh/wrtsh1 \
    sw/source/core/uibase/wrtsh/wrtsh2 \
    sw/source/core/uibase/wrtsh/wrtsh3 \
    sw/source/core/uibase/wrtsh/wrtsh4 \
    sw/source/core/uibase/wrtsh/wrtundo \
))

ifneq (,$(filter DBCONNECTIVITY,$(BUILD_TYPE)))
$(eval $(call gb_Library_add_exception_objects,sw,\
    sw/source/core/uibase/dbui/dbmgr \
    sw/source/core/uibase/dbui/dbtree \
    sw/source/core/uibase/dbui/dbui \
    sw/source/core/uibase/dbui/maildispatcher \
    sw/source/core/uibase/dbui/mailmergechildwindow \
    sw/source/core/uibase/dbui/mailmergehelper \
    sw/source/core/uibase/dbui/mmconfigitem \
    sw/source/core/uibase/dbui/swdbtoolsclient \
    sw/source/core/uibase/uno/unomailmerge \
))
endif

$(eval $(call gb_SdiTarget_SdiTarget,sw/sdi/swslots,sw/sdi/swriter))

$(eval $(call gb_SdiTarget_set_include,sw/sdi/swslots,\
    -I$(SRCDIR)/sw/inc \
    -I$(SRCDIR)/sw/sdi \
    -I$(SRCDIR)/svx/sdi \
    -I$(SRCDIR)/sfx2/sdi \
    $$(INCLUDE) \
))

# Runtime dependency for unit-tests
$(eval $(call gb_Library_use_restarget,sw,sw))

# vim: set noet sw=4 ts=4:
