/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ClassEnv;
import jas.CodeAttr;
import jas.Label;
import jas.VerificationTypeInfo;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class VerifyFrame {
    private static final int SAME_FRAME_S0_min = 0;
    private static final int SAME_FRAME_S0_max = 63;
    private static final int SAME_FRAME_S1_min = 64;
    private static final int SAME_FRAME_S1_max = 127;
    private static final int SAME_FRAME_S1 = 247;
    private static final int CHOP_FRAME_S0_min = 248;
    private static final int SAME_FRAME_S0 = 251;
    private static final int APPEND_FRAME_S0_max = 254;
    private static final int FULL_FRAME = 255;
    private Vector stack = new Vector();
    private Vector locals;
    private int offset;
    private Label off_label;
    private boolean offset_defined;

    public VerifyFrame(Vector InitialFrame) {
        this.locals = InitialFrame;
        if (this.locals == null) {
            this.locals = new Vector();
        }
        this.offset_defined = false;
    }

    private void defineOffset() throws jasError {
        if (this.offset_defined) {
            throw new jasError("offset already defined");
        }
        this.offset_defined = true;
    }

    public void setOffset(int offset) throws jasError {
        this.defineOffset();
        this.offset = offset;
    }

    public void setOffset(Label label) throws jasError {
        this.defineOffset();
        this.off_label = label;
    }

    public void addStackItem(String item, String val) throws jasError {
        this.stack.add(new VerificationTypeInfo(item, val));
    }

    public void addLocalsItem(String item, String val) throws jasError {
        this.locals.add(new VerificationTypeInfo(item, val));
    }

    public boolean haveOffset() {
        return this.offset_defined;
    }

    public Vector getFrame(int count) throws jasError {
        if (count > this.locals.size()) {
            throw new jasError("Counter exceed range", true);
        }
        Vector result = new Vector(this.locals);
        if (count != 0) {
            result.setSize(count);
        }
        return result;
    }

    public int getOffset(CodeAttr ce) throws jasError {
        if (this.off_label != null) {
            this.offset = ce.getPc(this.off_label);
            this.off_label = null;
        }
        return this.offset;
    }

    void resolve(ClassEnv e) {
        Enumeration en = this.stack.elements();
        while (en.hasMoreElements()) {
            ((VerificationTypeInfo)en.nextElement()).resolve(e);
        }
        en = this.locals.elements();
        while (en.hasMoreElements()) {
            ((VerificationTypeInfo)en.nextElement()).resolve(e);
        }
    }

    void write(ClassEnv e, CodeAttr ce, DataOutputStream out, VerifyFrame prev) throws IOException, jasError {
        int locals_size;
        int stack_size;
        int off;
        block19: {
            block20: {
                int prev_size;
                boolean can_compact;
                block23: {
                    block21: {
                        block22: {
                            off = this.getOffset(ce);
                            stack_size = this.stack.size();
                            locals_size = this.locals.size();
                            if (prev == this) break block19;
                            if (prev != null) {
                                int prev_off = prev.getOffset(ce);
                                if (prev_off >= off) {
                                    throw new jasError("Write unsorted StackMapFrame");
                                }
                                off -= prev_off + 1;
                            }
                            if (stack_size > 1) break block20;
                            can_compact = true;
                            prev_size = 0;
                            if (prev != null) break block21;
                            if (stack_size != 0) break block22;
                            if (locals_size <= 3) break block23;
                            can_compact = false;
                            break block23;
                        }
                        if (locals_size == 0) break block23;
                        can_compact = false;
                        break block23;
                    }
                    int cmpcn = locals_size;
                    prev_size = prev.locals.size();
                    int delta = locals_size - prev_size;
                    if (stack_size == 0) {
                        if (delta >= 0) {
                            if (delta > 3) {
                                can_compact = false;
                            }
                            cmpcn -= delta;
                        } else if (delta < -3) {
                            can_compact = false;
                        }
                    } else if (delta != 0) {
                        can_compact = false;
                    }
                    if (can_compact) {
                        while (--cmpcn >= 0) {
                            if (((VerificationTypeInfo)this.locals.elementAt(cmpcn)).isEqual(e, ce, (VerificationTypeInfo)prev.locals.elementAt(cmpcn))) continue;
                            can_compact = false;
                            break;
                        }
                    }
                }
                if (can_compact) {
                    if (stack_size != 0) {
                        if (off <= 63) {
                            out.writeByte((byte)(off + 64));
                        } else {
                            out.writeByte(-9);
                            out.writeShort((short)off);
                        }
                        ((VerificationTypeInfo)this.stack.elementAt(0)).write(e, ce, out);
                        return;
                    }
                    int wrdt = locals_size - prev_size;
                    if (wrdt == 0 && off <= 63) {
                        out.writeByte((byte)(off + 0));
                        return;
                    }
                    out.writeByte((byte)(251 + wrdt));
                    out.writeShort((short)off);
                    while (--wrdt >= 0) {
                        ((VerificationTypeInfo)this.locals.elementAt(prev_size++)).write(e, ce, out);
                    }
                    return;
                }
            }
            out.writeByte(-1);
        }
        out.writeShort((short)off);
        out.writeShort((short)locals_size);
        Enumeration en = this.locals.elements();
        while (--locals_size >= 0) {
            ((VerificationTypeInfo)en.nextElement()).write(e, ce, out);
        }
        out.writeShort((short)stack_size);
        en = this.stack.elements();
        while (--stack_size >= 0) {
            ((VerificationTypeInfo)en.nextElement()).write(e, ce, out);
        }
    }
}

