#! /bin/sh -f
#
# Copyright (C) 1998 Free Software Foundation, Inc.
# This file is part of the GNU C Library and contains tests for
# the rpmatch(3)-implementation.
# contributed by Jochen Hein <jochen.hein@delphi.central.de>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

common_objpfx=$1
IFS=""
rc=0
while read locale string result dummy; do
    if [ "$locale" != "#" ]; then
	LOCPATH=${common_objpfx}localedata \
	${common_objpfx}elf/ld.so --library-path $common_objpfx \
	${common_objpfx}localedata/tst-rpmatch $locale $string $result \
	|| exit 1
    fi
done <<EOF
# These are the tests for rpmatch in glibc.  Each line contains one test,
# comments start with # in the first column.  The fields are seperated
# by paragraph signs and contain: the locale, the string, the expected
# return value of rpmatch(3).  If the test fails, test-rpmatch prints
# all these informations
CYes1
Cyes1
CYES1
CYeS1
CYEs1
CyEs1
CyES1
CyeS1
CNo0
Cno0
# Uh, that's nonsense
Cnonsens0
CError-1
de_DEYes1
de_DEJa1
de_DEJammerschade1
de_DEdejavu-1
de_DENein0
de_DEFehler-1
de_DEjein1
EOF

rc=$?
if [ $rc -eq 1 ]; then
    echo "Errors"
fi
exit $rc
